/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import com.afunproject.dawncraft.network.ToastMessage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkDirection;

public interface Toasts {
    public void sendToast(ServerPlayer var1, byte var2);

    public void readNBT(CompoundTag var1);

    public void readNBT(ByteTag var1);

    public ByteTag writeNBT();

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        private final Toasts impl = new Implementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == DCCapabilities.TOASTS ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.impl.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            if (nbt instanceof CompoundTag) {
                this.impl.readNBT((CompoundTag)nbt);
            }
            if (nbt instanceof ByteTag) {
                this.impl.readNBT((ByteTag)nbt);
            }
        }
    }

    public static class Implementation
    implements Toasts {
        private byte flags;

        @Override
        public void sendToast(ServerPlayer player, byte b) {
            if ((this.flags & b) == b) {
                return;
            }
            this.flags = (byte)(this.flags + b);
            DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new ToastMessage(b), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            if (nbt.m_128441_("0") && nbt.m_128471_("0")) {
                this.flags = (byte)(this.flags + 1);
            }
            if (nbt.m_128441_("1") && nbt.m_128471_("1")) {
                this.flags = (byte)(this.flags + 2);
            }
        }

        @Override
        public void readNBT(ByteTag nbt) {
            this.flags = nbt.m_7063_();
        }

        @Override
        public ByteTag writeNBT() {
            return ByteTag.m_128266_((byte)this.flags);
        }
    }
}

