/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkDirection;
import net.smileycorp.atlas.api.network.SimpleIntMessage;

public interface SageQuestTracker {
    public void checkAnimal(Player var1, Animal var2);

    public int getCheckedCount();

    public boolean isActive();

    public void setActive(boolean var1);

    public void readNBT(CompoundTag var1);

    public CompoundTag writeNBT();

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final SageQuestTracker impl = new Implementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == DCCapabilities.SAGE_QUEST_TRACKER ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.writeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.readNBT(nbt);
        }
    }

    public static class Implementation
    implements SageQuestTracker {
        protected List<String> animals = Lists.newArrayList();
        protected boolean isActive;

        @Override
        public void checkAnimal(Player player, Animal animal) {
            String name = animal.m_6095_().m_20675_();
            if (!this.animals.contains(name)) {
                this.animals.add(name);
                if (this.animals.size() <= 10 && player instanceof ServerPlayer) {
                    DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleIntMessage(this.animals.size()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        }

        @Override
        public int getCheckedCount() {
            return this.animals.size();
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void setActive(boolean active) {
            this.isActive = active;
            if (!active) {
                this.animals.clear();
            }
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            if (nbt.m_128441_("animals")) {
                this.isActive = true;
            }
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.isActive) {
                ListTag list = new ListTag();
                for (String animal : this.animals) {
                    list.add((Object)StringTag.m_129297_((String)animal));
                }
                nbt.m_128365_("animals", (Tag)list);
            }
            return nbt;
        }
    }
}

