/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.ModUtils;
import com.afunproject.dawncraft.capability.DCCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface RestrictBlock {
    public boolean shouldRestrict(Mob var1);

    public BlockPos getCenter(Mob var1);

    public int getRange();

    public void readNBT(CompoundTag var1);

    public CompoundTag writeNBT(CompoundTag var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final RestrictBlock impl = new Implementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == DCCapabilities.RESTRICT_BLOCK ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.writeNBT(new CompoundTag());
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.readNBT(nbt);
        }
    }

    public static class Implementation
    implements RestrictBlock {
        protected boolean shouldRestrict;
        protected int timesSpawned = 0;
        protected BlockPos center = null;
        protected int range = -1;

        @Override
        public boolean shouldRestrict(Mob entity) {
            BlockPos pos = this.getCenter(entity);
            if (entity == null || pos == null || this.range < 0) {
                return false;
            }
            return this.shouldRestrict && entity.m_5448_() == null && entity.m_20238_(Vec3.m_82512_((Vec3i)pos)) >= (double)(this.range * this.range);
        }

        @Override
        public BlockPos getCenter(Mob entity) {
            if (this.range >= 0 && this.center == null) {
                this.center = entity.m_142538_();
            }
            return this.center;
        }

        @Override
        public int getRange() {
            return this.range;
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            if (nbt.m_128441_("shouldRestrict")) {
                this.shouldRestrict = nbt.m_128471_("shouldRestrict");
            }
            if (nbt.m_128441_("timesSpawned")) {
                this.timesSpawned = nbt.m_128451_("timesSpawned");
            }
            if (nbt.m_128441_("center")) {
                this.center = (BlockPos)ModUtils.readPosFromNBT(nbt.m_128469_("center"), true);
            }
            if (nbt.m_128441_("range")) {
                this.range = nbt.m_128451_("range");
            }
        }

        @Override
        public CompoundTag writeNBT(CompoundTag nbt) {
            if (this.shouldRestrict) {
                nbt.m_128379_("shouldRestrict", this.shouldRestrict);
            }
            if (this.timesSpawned != 0) {
                nbt.m_128405_("timesSpawned", this.timesSpawned);
            }
            if (this.center != null) {
                nbt.m_128365_("center", (Tag)ModUtils.savePosToNBT((Vec3i)this.center));
            }
            if (this.range >= 0) {
                nbt.m_128405_("range", this.range);
            }
            return nbt;
        }
    }
}

