/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.capability.Invasion;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface Invader {
    public Invasion getInvasion();

    public void setInvasion(Player var1);

    public void load(CompoundTag var1);

    public CompoundTag save();

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        protected final Invader impl;

        public Provider(LivingEntity entity) {
            this.impl = new Implementation(entity);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == DCCapabilities.INVADER ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.save();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.load(nbt);
        }
    }

    public static class Implementation
    implements Invader {
        private final LivingEntity entity;
        private UUID player;
        private Invasion invasion;

        public Implementation(LivingEntity entity) {
            this.entity = entity;
        }

        @Override
        public Invasion getInvasion() {
            if (this.player == null || this.entity == null) {
                return null;
            }
            Player player = this.entity.f_19853_.m_46003_(this.player);
            if (player == null) {
                return null;
            }
            if (this.invasion == null) {
                this.invasion = (Invasion)player.getCapability(DCCapabilities.INVASIONS).orElse(null);
            }
            return this.invasion;
        }

        @Override
        public void setInvasion(Player player) {
            this.player = player.m_142081_();
        }

        @Override
        public void load(CompoundTag tag) {
            if (tag.m_128403_("player")) {
                this.player = NbtUtils.m_129233_((Tag)tag.m_128423_("player"));
            }
            if (this.entity != null && this.player != null) {
                Player player = this.entity.f_19853_.m_46003_(this.player);
                if (player == null) {
                    return;
                }
                this.invasion = (Invasion)player.getCapability(DCCapabilities.INVASIONS).orElse(null);
            }
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            if (this.player != null) {
                tag.m_128365_("player", (Tag)NbtUtils.m_129226_((UUID)this.player));
            }
            return tag;
        }
    }
}

