/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class ModUtils {
    public static boolean isWater(BlockState oldState) {
        Block block = oldState.m_60734_();
        if (oldState.m_60767_() == Material.f_76305_) {
            return true;
        }
        if (block instanceof SimpleWaterloggedBlock) {
            return (Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_);
        }
        return oldState.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public static String getPosString(BlockPos pos) {
        return "(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")";
    }

    public static CompoundTag savePosToNBT(Vec3i center) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("x", center.m_123341_());
        nbt.m_128405_("y", center.m_123342_());
        nbt.m_128405_("z", center.m_123343_());
        return nbt;
    }

    public static Vec3i readPosFromNBT(CompoundTag nbt, boolean isBlockPos) {
        int x = nbt.m_128451_("x");
        int y = nbt.m_128451_("y");
        int z = nbt.m_128451_("z");
        return isBlockPos ? new BlockPos(x, y, z) : new Vec3i(x, y, z);
    }

    public static boolean isValidResourceLocation(String structure) {
        try {
            new ResourceLocation(structure.replace("#", ""));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

