/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft;

import com.afunproject.dawncraft.DCEntityTags;
import com.afunproject.dawncraft.capability.DCCapabilities;
import com.afunproject.dawncraft.capability.Invader;
import com.afunproject.dawncraft.capability.Invasion;
import com.afunproject.dawncraft.capability.RestrictBlock;
import com.afunproject.dawncraft.capability.SageQuestTracker;
import com.afunproject.dawncraft.capability.Toasts;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.afunproject.dawncraft.dungeon.item.RebirthStaffItem;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.afunproject.dawncraft.entities.ai.GoToRestrictionGoal;
import com.afunproject.dawncraft.integration.apotheosis.ApotheosisCompat;
import com.afunproject.dawncraft.integration.champions.ChampionsIntegration;
import com.afunproject.dawncraft.integration.epicfight.EpicFightCompat;
import com.afunproject.dawncraft.integration.ironspellbooks.IronsSpellbooksCompat;
import com.afunproject.dawncraft.integration.suplementaries.RitualChecker;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dawncraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventListener {
    private static final UUID BOSS_MODIFIER = UUID.fromString("dd686c7a-e2c7-479c-96d5-3e193b35c7b8");
    public static final List<Consumer<EntityAttributeCreationEvent>> ATTRIBUTE_SUPPLIERS = Lists.newArrayList();

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player != null && !(player instanceof FakePlayer)) {
            if (player.f_19853_.f_46443_) {
                return;
            }
            LazyOptional optional = player.getCapability(DCCapabilities.INVASIONS);
            if (optional.isPresent()) {
                ((Invasion)optional.resolve().get()).tryToSpawnInvasion();
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        IronGolem golem;
        Mob entity;
        LazyOptional optional;
        if (event.getEntity().m_6095_().m_204039_(DCEntityTags.BOSSES) && event.getEntity() instanceof Mob) {
            Mob boss = (Mob)event.getEntity();
            int players = 0;
            for (Player player : boss.f_19853_.m_6907_()) {
                if (!(player.m_20270_((Entity)boss) <= 100.0f)) continue;
                ++players;
            }
            if (players > 1) {
                AttributeInstance health;
                AttributeInstance damage = boss.m_21051_(Attributes.f_22281_);
                if (damage != null) {
                    double damage_multiplier = Math.max(1.5, Math.pow(1.05, players - 1));
                    damage.m_22120_(BOSS_MODIFIER);
                    damage.m_22125_(new AttributeModifier(BOSS_MODIFIER, "dawncraft_multiplayer_scaling", damage_multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
                if ((health = boss.m_21051_(Attributes.f_22276_)) != null) {
                    double health_multiplier = Math.max(2.0, Math.pow(1.25, players - 1));
                    health.m_22120_(BOSS_MODIFIER);
                    health.m_22125_(new AttributeModifier(BOSS_MODIFIER, "dawncraft_multiplayer_scaling", health_multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    boss.m_21153_((float)health.m_22135_());
                }
            }
        }
        if (event.getEntity() instanceof Mob && (optional = (entity = (Mob)event.getEntity()).getCapability(DCCapabilities.RESTRICT_BLOCK)).isPresent()) {
            RestrictBlock cap = (RestrictBlock)optional.resolve().get();
            entity.f_21345_.m_25352_(1, (Goal)new GoToRestrictionGoal(entity, cap));
        }
        if (event.getEntity() instanceof IronGolem && !(golem = (IronGolem)event.getEntity()).m_28876_()) {
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 10000000, 0, false, false));
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 10000000, 0, false, false));
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10000000, 0, false, false));
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            if (!player.m_150110_().f_35938_) {
                player.m_143403_(GameType.SURVIVAL);
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player player = event.getPlayer();
        original.reviveCaps();
        LazyOptional soptionalOld = original.getCapability(DCCapabilities.SAGE_QUEST_TRACKER);
        LazyOptional soptional = player.getCapability(DCCapabilities.SAGE_QUEST_TRACKER);
        if (soptionalOld.isPresent() && soptional.isPresent()) {
            ((SageQuestTracker)soptional.resolve().get()).readNBT(((SageQuestTracker)soptionalOld.resolve().get()).writeNBT());
        }
        LazyOptional toptionalOld = original.getCapability(DCCapabilities.TOASTS);
        LazyOptional toptional = player.getCapability(DCCapabilities.TOASTS);
        if (toptionalOld.isPresent() && toptional.isPresent()) {
            ((Toasts)toptional.resolve().get()).readNBT(((Toasts)toptionalOld.resolve().get()).writeNBT());
        }
        if (original.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get())) {
            player.m_7292_(new MobEffectInstance((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get(), 3600, Math.min(4, original.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_() + 1), true, true));
        } else {
            player.m_7292_(new MobEffectInstance((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get(), 3600, 0, true, true));
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        if (level.f_46443_) {
            return;
        }
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (stack == null || state == null) {
            return;
        }
        if (!state.m_60713_(Blocks.f_50201_) || !stack.m_150930_((Item)DungeonItems.REBIRTH_STAFF.get())) {
            return;
        }
        if (RebirthStaffItem.isPowered(stack) | !ModList.get().isLoaded("supplementaries")) {
            return;
        }
        if (!RitualChecker.isValid(level, pos)) {
            return;
        }
        RitualChecker.startRitual(stack, level, pos);
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void livingHurt(LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity.f_19853_.f_46443_ | !(source.m_7639_() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source.m_7639_();
        if (attacker.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)DungeonItems.SLAYERS_BLADE.get())) {
            if (attacker instanceof Player && ModList.get().isLoaded("epicfight")) {
                if (EpicFightCompat.isCombatMode((Player)attacker)) {
                    event.setAmount(entity.m_21233_() * 0.1f);
                } else {
                    event.setAmount(entity.m_21233_() * 0.1f);
                }
            }
        } else if (attacker.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)DungeonItems.EXECUTIONER.get()) && (double)entity.m_21223_() < (double)entity.m_21233_() * 0.15) {
            attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11860_, SoundSource.PLAYERS, 1.0f, attacker.m_21187_().nextFloat());
            event.setAmount(entity.m_21223_());
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        LazyOptional optional;
        DamageSource source;
        LivingEntity entity = event.getEntityLiving();
        if (entity.f_19853_.f_46443_) {
            return;
        }
        if (entity instanceof Player && (source = event.getSource()).m_7639_() != null && source.m_7639_().m_6095_().m_204039_(DCEntityTags.BOSSES)) {
            LivingEntity boss = (LivingEntity)source.m_7639_();
            boss.m_5634_(boss.m_21233_() * 0.25f);
        }
        if (!(optional = entity.getCapability(DCCapabilities.INVADER)).isPresent()) {
            return;
        }
        Invasion invasion = ((Invader)optional.orElse(null)).getInvasion();
        if (invasion == null) {
            return;
        }
        invasion.entityKilled(entity);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void livingDeathEnd(LivingDeathEvent event) {
        Level level = event.getEntity().f_19853_;
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46133_) && ModList.get().isLoaded("apotheosis")) {
            ApotheosisCompat.fixNBT(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickItem event) {
        if (ModList.get().isLoaded("irons_spellbooks") && IronsSpellbooksCompat.isSpellBook(event.getItemStack())) {
            event.getEntityLiving().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 3));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerTick(LivingEvent.LivingVisibilityEvent event) {
        Entity entity = event.getLookingEntity();
        if (!event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_150930_((Item)DungeonItems.MASK_OF_ATHORA.get())) {
            return;
        }
        if (entity.m_6095_().m_204039_(DCEntityTags.BYPASSES_MASK_OF_ATHORA)) {
            return;
        }
        if (ModList.get().isLoaded("champions") && ChampionsIntegration.isChampion(entity)) {
            return;
        }
        event.modifyVisibility(0.0);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        for (Consumer<EntityAttributeCreationEvent> supplier : ATTRIBUTE_SUPPLIERS) {
            supplier.accept(event);
        }
    }
}

