/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_forge.util;

import com.natamus.areas_common_forge.config.ConfigHandler;
import com.natamus.areas_common_forge.data.AreaVariables;
import com.natamus.areas_common_forge.data.ClientConstants;
import com.natamus.areas_common_forge.data.GUIVariables;
import com.natamus.areas_common_forge.functions.ZoneFunctions;
import com.natamus.areas_common_forge.objects.AreaObject;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.SignFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.collective_common_forge.functions.TileEntityFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class Util {
    public static AreaObject getAreaSign(Level level, BlockPos signPos) {
        BlockEntity blockEntity = level.m_7702_(signPos);
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
        StringBuilder areaNameBuilder = new StringBuilder();
        String rgb = "";
        String zonePrefix = "Area";
        int radius = ConfigHandler.defaultAreaRadius;
        boolean customrgb = false;
        List signLines = SignFunctions.getSignText((SignBlockEntity)signBlockEntity);
        HashMap areaObjectHashMap = (HashMap)HashMapFunctions.computeIfAbsent(AreaVariables.areaObjects, (Object)level, k -> new HashMap());
        if (areaObjectHashMap != null && areaObjectHashMap.containsKey(signPos)) {
            AreaObject cachedAreaObject = (AreaObject)areaObjectHashMap.get(signPos);
            if (cachedAreaObject.signLines.equals(signLines)) {
                return cachedAreaObject;
            }
            AreaVariables.areaObjects.get(level).remove(signPos);
        }
        int i = -1;
        for (String line : signLines) {
            if (++i == 0 && !ZoneFunctions.hasZonePrefix(line)) {
                return null;
            }
            if (line.length() < 1) continue;
            Integer possibleradius = ZoneFunctions.getZonePrefixgetRadius(line.toLowerCase());
            if (possibleradius >= 0) {
                radius = possibleradius;
                continue;
            }
            String possiblergb = ZoneFunctions.getZoneRGB(line.toLowerCase());
            if (!possiblergb.equals("")) {
                rgb = possiblergb;
                continue;
            }
            if (ZoneFunctions.hasZonePrefix(line)) continue;
            if (!areaNameBuilder.toString().equals("")) {
                areaNameBuilder.append(" ");
            }
            areaNameBuilder.append(line);
        }
        String areaName = areaNameBuilder.toString();
        return new AreaObject(level, signPos, areaName, radius, rgb, signLines);
    }

    /*
     * WARNING - void declaration
     */
    public static void updateAreaSign(Level level, BlockPos signPos, SignBlockEntity signBlockEntity, List<String> signLines, String areaName, String zonePrefix, String rgb, int radius, boolean customrgb) {
        int i;
        boolean setradius = false;
        int maxradius = ConfigHandler.radiusAroundPlayerToCheckForSigns;
        if (radius > maxradius) {
            radius = maxradius;
            setradius = true;
        }
        StringBuilder areaNameBuilder = new StringBuilder();
        boolean shouldUpdateSign = false;
        if (areaName.trim().equals("")) {
            ArrayList<Object> newSignContentList = new ArrayList<Object>();
            newSignContentList.add("[" + zonePrefix + "] " + radius);
            if (customrgb) {
                newSignContentList.add("[RGB] " + rgb);
            } else {
                newSignContentList.add("");
            }
            if (ConfigHandler.giveUnnamedAreasRandomName) {
                String string = Util.getRandomAreaName();
                for (String word : string.split(" ")) {
                    if (newSignContentList.size() != 8) {
                        newSignContentList.add(word);
                        continue;
                    }
                    break;
                }
            } else {
                newSignContentList.add("Unnamed area");
            }
            i = 0;
            for (String string : newSignContentList) {
                signBlockEntity.m_59732_(i, (Component)new TextComponent(string));
                ++i;
            }
            shouldUpdateSign = true;
        }
        if (!shouldUpdateSign && (radius == 0 || setradius)) {
            i = 0;
            for (String string : signLines) {
                void var15_19;
                if (i == 0) {
                    String string2 = "[" + zonePrefix + "] " + radius;
                }
                signBlockEntity.m_59732_(i, (Component)new TextComponent((String)var15_19));
                ++i;
            }
            shouldUpdateSign = true;
        }
        if (shouldUpdateSign) {
            TileEntityFunctions.updateTileEntity((Level)level, (BlockPos)signPos, (BlockEntity)signBlockEntity);
        }
    }

    public static void enterArea(AreaObject areaObject, Player player) {
        if (Util.playerIsEditingASign()) {
            return;
        }
        AreaObject currentAreaObject = Util.getAreaSign(areaObject.level, areaObject.location);
        if (currentAreaObject.signLines != areaObject.signLines) {
            AreaVariables.enteredAreas.remove(areaObject);
            AreaVariables.areaObjects.get(areaObject.level).put(areaObject.location, currentAreaObject);
            areaObject = currentAreaObject;
        }
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, true);
        if (!AreaVariables.enteredAreas.contains(areaObject)) {
            AreaVariables.enteredAreas.add(areaObject);
        }
        if (shouldMessage) {
            String message = ConfigHandler.enterPrefix + areaObject.areaName + ConfigHandler.enterSuffix;
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static void exitArea(AreaObject areaObject, Player player) {
        AreaVariables.enteredAreas.remove(areaObject);
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, false);
        if (shouldMessage) {
            String message = ConfigHandler.leavePrefix + areaObject.areaName + ConfigHandler.leaveSuffix;
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static void removedArea(AreaObject areaObject, Player player) {
        AreaVariables.areaObjects.get(areaObject.level).remove(areaObject.location);
        AreaVariables.enteredAreas.remove(areaObject);
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, false);
        if (shouldMessage) {
            String message = "The area " + areaObject.areaName + " no longer exists.";
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static boolean playerIsEditingASign() {
        Screen screen = ClientConstants.mc.f_91080_;
        return screen instanceof SignEditScreen;
    }

    public static boolean shouldMessagePlayer(AreaObject areaObject, boolean isEntering) {
        if (areaObject.areaName.equals("")) {
            return false;
        }
        for (AreaObject enteredAreaObject : AreaVariables.enteredAreas) {
            if (enteredAreaObject.equals(areaObject) || !areaObject.signLines.equals(enteredAreaObject.signLines)) continue;
            return false;
        }
        if (isEntering) {
            return ConfigHandler.showEnterMessage;
        }
        return ConfigHandler.showLeaveMessage;
    }

    public static void areaChangeMessage(Player player, String message, String rgb) {
        if (ConfigHandler.sendChatMessages) {
            StringFunctions.sendMessage((Player)player, (String)message, (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        if (ConfigHandler.showHUDMessages) {
            GUIVariables.ticksLeftBeforeFade = ConfigHandler.HUDMessageFadeDelayMs / 50;
            GUIVariables.hudMessage = message;
            GUIVariables.rgb = rgb;
            GUIVariables.guiOpacity = 255;
        }
    }

    public static Boolean isSignBlock(Block block) {
        return block instanceof SignBlock;
    }

    public static Boolean isSignItem(Item item) {
        return Util.isSignBlock(Block.m_49814_((Item)item));
    }

    private static String getRandomAreaName() {
        return (String)GlobalVariables.areaNames.get(GlobalVariables.random.nextInt(GlobalVariables.areaNames.size()));
    }
}

