/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.natamus.areas_common_forge.data.AreaVariables;
import com.natamus.areas_common_forge.functions.ZoneFunctions;
import com.natamus.areas_common_forge.objects.AreaObject;
import com.natamus.areas_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.FABFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.Vec3;

public class ClientCommandAreas {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"areas").requires(iCommandSender -> iCommandSender.m_81373_() instanceof Player)).executes(command -> ClientCommandAreas.areas((Player)ClientCommandAreas.mc.f_91074_)));
    }

    public static int areas(Player player) {
        if (player == null) {
            return 0;
        }
        Level level = player.f_19853_;
        Vec3 pvec = player.m_20182_();
        boolean sentfirst = false;
        List signsaround = FABFunctions.getAllTileEntityPositionsNearbyEntity((BlockEntityType)BlockEntityType.f_58924_, (Integer)200, (Level)level, (Entity)player);
        for (BlockPos signpos : signsaround) {
            BlockEntity te = level.m_7702_(signpos);
            if (!(te instanceof SignBlockEntity) || !ZoneFunctions.hasZonePrefix((SignBlockEntity)te)) continue;
            if (!sentfirst) {
                StringFunctions.sendMessage((Player)player, (String)"Area sign positions around you:", (ChatFormatting)ChatFormatting.DARK_GREEN);
                sentfirst = true;
            }
            Object prefix = "a";
            if (((HashMap)HashMapFunctions.computeIfAbsent(AreaVariables.areaObjects, (Object)level, k -> new HashMap())).containsKey(signpos)) {
                AreaObject ao = AreaVariables.areaObjects.get(level).get(signpos);
                prefix = ao.areaName + " a";
            } else {
                Util.getAreaSign(level, signpos);
            }
            double distance = (double)Math.round(Math.sqrt(signpos.m_123331_(new Vec3i(Mth.m_14107_((double)pvec.f_82479_), Mth.m_14107_((double)pvec.f_82480_), Mth.m_14107_((double)pvec.f_82481_)))) * 100.0) / 100.0;
            String blocksaway = " (" + distance + " blocks)";
            StringFunctions.sendMessage((Player)player, (String)(" " + (String)prefix + "t x=" + signpos.m_123341_() + ", y=" + signpos.m_123342_() + ", z=" + signpos.m_123343_() + "." + blocksaway), (ChatFormatting)ChatFormatting.YELLOW);
        }
        if (!sentfirst) {
            StringFunctions.sendMessage((Player)player, (String)"There are no area signs around you.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        return 1;
    }
}

