/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.client;

import com.nameless.impactful.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
public class CameraEngine {
    private static CameraEngine instance;
    private int cameraShakeTime = 0;
    private float cameraShakeStrength = 0.0f;
    private float frequency = 0.0f;

    public static CameraEngine getInstance() {
        return instance;
    }

    public CameraEngine() {
        instance = this;
    }

    public void shakeCamera(int time, float strength, float frequency) {
        if (strength > this.cameraShakeStrength) {
            this.cameraShakeStrength = strength;
            this.cameraShakeTime = time;
            this.frequency = frequency;
        }
    }

    public void shakeCamera(int time, float strength) {
        this.shakeCamera(time, strength, 3.0f);
    }

    public void reset() {
        this.cameraShakeStrength = 0.0f;
        this.frequency = 0.0f;
    }

    @Mod.EventBusSubscriber(modid="impactful", value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent(priority=EventPriority.LOW)
        public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (CameraEngine.instance.cameraShakeTime > 0) {
                --CameraEngine.instance.cameraShakeTime;
                float delta = Minecraft.m_91087_().m_91296_();
                float ticksExistedDelta = (float)player.f_19797_ + delta;
                float k = CameraEngine.instance.cameraShakeStrength / 4.0f * ((Double)ClientConfig.SCREEN_SHAKE_AMPLITUDE_MULTIPLY.get()).floatValue();
                float f = CameraEngine.instance.frequency;
                if (!((Boolean)ClientConfig.DISABLE_SCREEN_SHAKE.get()).booleanValue() && !Minecraft.m_91087_().m_91104_()) {
                    event.setPitch((float)((double)event.getPitch() + (double)k * Math.cos(ticksExistedDelta * f + 2.0f)));
                    event.setYaw((float)((double)event.getYaw() + (double)k * Math.cos(ticksExistedDelta * f + 1.0f)));
                    event.setRoll((float)((double)event.getRoll() + (double)k * Math.cos(ticksExistedDelta * f)));
                }
            } else if (CameraEngine.instance.cameraShakeStrength != 0.0f) {
                instance.reset();
            }
        }
    }
}

