/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.worldgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.infrastructure.worldgen.AllFeatures;
import com.simibubi.create.infrastructure.worldgen.ConfigDrivenLayeredOreFeatureConfiguration;
import com.simibubi.create.infrastructure.worldgen.ConfigDrivenOreFeatureConfiguration;
import com.simibubi.create.infrastructure.worldgen.ConfigDrivenPlacement;
import com.simibubi.create.infrastructure.worldgen.LayerPattern;
import com.simibubi.create.infrastructure.worldgen.LayeredOreFeature;
import com.simibubi.create.infrastructure.worldgen.StandardOreFeature;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.jetbrains.annotations.Nullable;

public class OreFeatureConfigEntry
extends ConfigBase {
    public static final Map<ResourceLocation, OreFeatureConfigEntry> ALL = new HashMap<ResourceLocation, OreFeatureConfigEntry>();
    public static final Codec<OreFeatureConfigEntry> CODEC = ResourceLocation.f_135803_.comapFlatMap(OreFeatureConfigEntry::read, entry -> entry.id);
    public final ResourceLocation id;
    public final ConfigBase.ConfigInt clusterSize;
    public final ConfigBase.ConfigFloat frequency;
    public final ConfigBase.ConfigInt minHeight;
    public final ConfigBase.ConfigInt maxHeight;
    private BiomeExtension biomeExt;
    private DatagenExtension datagenExt;

    public OreFeatureConfigEntry(ResourceLocation id, int clusterSize, float frequency, int minHeight, int maxHeight) {
        this.id = id;
        this.clusterSize = this.i(clusterSize, 0, "clusterSize", new String[0]);
        this.frequency = this.f(frequency, 0.0f, 512.0f, "frequency", "Amount of clusters generated per Chunk.", "  >1 to spawn multiple.", "  <1 to make it a chance.", "  0 to disable.");
        this.minHeight = this.i(minHeight, "minHeight", new String[0]);
        this.maxHeight = this.i(maxHeight, "maxHeight", new String[0]);
        ALL.put(id, this);
    }

    public BiomeExtension biomeExt() {
        if (this.biomeExt == null) {
            this.biomeExt = new BiomeExtension();
        }
        return this.biomeExt;
    }

    @Nullable
    public StandardDatagenExtension standardDatagenExt() {
        DatagenExtension datagenExtension;
        if (this.datagenExt == null) {
            this.datagenExt = new StandardDatagenExtension();
        }
        if ((datagenExtension = this.datagenExt) instanceof StandardDatagenExtension) {
            StandardDatagenExtension standard = (StandardDatagenExtension)datagenExtension;
            return standard;
        }
        return null;
    }

    @Nullable
    public LayeredDatagenExtension layeredDatagenExt() {
        DatagenExtension datagenExtension;
        if (this.datagenExt == null) {
            this.datagenExt = new LayeredDatagenExtension();
        }
        if ((datagenExtension = this.datagenExt) instanceof LayeredDatagenExtension) {
            LayeredDatagenExtension layered = (LayeredDatagenExtension)datagenExtension;
            return layered;
        }
        return null;
    }

    @Nullable
    public DatagenExtension datagenExt() {
        if (this.datagenExt != null) {
            return this.datagenExt;
        }
        return null;
    }

    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.registerAll(builder);
    }

    @Override
    public String getName() {
        return this.id.m_135815_();
    }

    public static DataResult<OreFeatureConfigEntry> read(ResourceLocation id) {
        OreFeatureConfigEntry entry = ALL.get(id);
        if (entry != null) {
            return DataResult.success((Object)entry);
        }
        return DataResult.error((String)("Not a valid OreFeatureConfigEntry: " + id));
    }

    public class BiomeExtension {
        public ResourceLocation placedFeatureLocation;
        public Predicate<BiomeLoadingEvent> biomePredicate;

        public BiomeExtension() {
            this.placedFeatureLocation = OreFeatureConfigEntry.this.id;
            this.biomePredicate = e -> false;
        }

        public BiomeExtension feature(ResourceLocation placedFeature) {
            this.placedFeatureLocation = placedFeature;
            return this;
        }

        public BiomeExtension predicate(Predicate<BiomeLoadingEvent> predicate) {
            this.biomePredicate = predicate;
            return this;
        }

        public void modifyBiomes(BiomeLoadingEvent event, Registry<PlacedFeature> registry) {
            Optional optionalFeature;
            if (this.biomePredicate.test(event) && (optionalFeature = registry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)this.placedFeatureLocation))).isPresent()) {
                event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)optionalFeature.get());
            }
        }

        public OreFeatureConfigEntry parent() {
            return OreFeatureConfigEntry.this;
        }
    }

    public abstract class DatagenExtension {
        public abstract ConfiguredFeature<?, ?> createConfiguredFeature(RegistryAccess var1);

        public PlacedFeature createPlacedFeature(RegistryAccess registryAccess) {
            Registry featureRegistry = registryAccess.m_175515_(Registry.f_122881_);
            Holder featureHolder = featureRegistry.m_203538_(ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)OreFeatureConfigEntry.this.id));
            return new PlacedFeature(featureHolder, List.of(new ConfigDrivenPlacement(OreFeatureConfigEntry.this)));
        }

        public OreFeatureConfigEntry parent() {
            return OreFeatureConfigEntry.this;
        }
    }

    public class StandardDatagenExtension
    extends DatagenExtension {
        public NonNullSupplier<? extends Block> block;
        public NonNullSupplier<? extends Block> deepBlock;
        public NonNullSupplier<? extends Block> netherBlock;

        public StandardDatagenExtension withBlock(NonNullSupplier<? extends Block> block) {
            this.block = block;
            this.deepBlock = block;
            return this;
        }

        public StandardDatagenExtension withBlocks(Couple<NonNullSupplier<? extends Block>> blocks) {
            this.block = (NonNullSupplier)blocks.getFirst();
            this.deepBlock = (NonNullSupplier)blocks.getSecond();
            return this;
        }

        public StandardDatagenExtension withNetherBlock(NonNullSupplier<? extends Block> block) {
            this.netherBlock = block;
            return this;
        }

        @Override
        public ConfiguredFeature<?, ?> createConfiguredFeature(RegistryAccess registryAccess) {
            ArrayList<OreConfiguration.TargetBlockState> targetStates = new ArrayList<OreConfiguration.TargetBlockState>();
            if (this.block != null) {
                targetStates.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)this.block.get()).m_49966_()));
            }
            if (this.deepBlock != null) {
                targetStates.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)this.deepBlock.get()).m_49966_()));
            }
            if (this.netherBlock != null) {
                targetStates.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)((Block)this.netherBlock.get()).m_49966_()));
            }
            ConfigDrivenOreFeatureConfiguration config = new ConfigDrivenOreFeatureConfiguration(OreFeatureConfigEntry.this, 0.0f, targetStates);
            return new ConfiguredFeature((Feature)((StandardOreFeature)((Object)AllFeatures.STANDARD_ORE.get())), (FeatureConfiguration)config);
        }
    }

    public class LayeredDatagenExtension
    extends DatagenExtension {
        public final List<NonNullSupplier<LayerPattern>> layerPatterns = new ArrayList<NonNullSupplier<LayerPattern>>();

        public LayeredDatagenExtension withLayerPattern(NonNullSupplier<LayerPattern> pattern) {
            this.layerPatterns.add(pattern);
            return this;
        }

        @Override
        public ConfiguredFeature<?, ?> createConfiguredFeature(RegistryAccess registryAccess) {
            List<LayerPattern> layerPatterns = this.layerPatterns.stream().map(NonNullSupplier::get).toList();
            ConfigDrivenLayeredOreFeatureConfiguration config = new ConfigDrivenLayeredOreFeatureConfiguration(OreFeatureConfigEntry.this, 0.0f, layerPatterns);
            return new ConfiguredFeature((Feature)((LayeredOreFeature)((Object)AllFeatures.LAYERED_ORE.get())), (FeatureConfiguration)config);
        }
    }
}

