/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import javax.annotation.Nullable;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidHelper {
    public static boolean isWater(Fluid fluid) {
        return FluidHelper.convertToStill(fluid) == Fluids.f_76193_;
    }

    public static boolean isLava(Fluid fluid) {
        return FluidHelper.convertToStill(fluid) == Fluids.f_76195_;
    }

    public static boolean isTag(Fluid fluid, TagKey<Fluid> tag) {
        return fluid.m_205067_(tag);
    }

    public static boolean isTag(FluidState fluid, TagKey<Fluid> tag) {
        return fluid.m_205070_(tag);
    }

    public static boolean isTag(FluidStack fluid, TagKey<Fluid> tag) {
        return FluidHelper.isTag(fluid.getFluid(), tag);
    }

    public static boolean hasBlockState(Fluid fluid) {
        BlockState blockState = fluid.m_76145_().m_76188_();
        return blockState != null && blockState != Blocks.f_50016_.m_49966_();
    }

    public static FluidStack copyStackWithAmount(FluidStack fs, int amount) {
        if (amount <= 0) {
            return FluidStack.EMPTY;
        }
        if (fs.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack copy = fs.copy();
        copy.setAmount(amount);
        return copy;
    }

    public static Fluid convertToFlowing(Fluid fluid) {
        if (fluid == Fluids.f_76193_) {
            return Fluids.f_76192_;
        }
        if (fluid == Fluids.f_76195_) {
            return Fluids.f_76194_;
        }
        if (fluid instanceof ForgeFlowingFluid) {
            return ((ForgeFlowingFluid)fluid).m_5615_();
        }
        return fluid;
    }

    public static Fluid convertToStill(Fluid fluid) {
        if (fluid == Fluids.f_76192_) {
            return Fluids.f_76193_;
        }
        if (fluid == Fluids.f_76194_) {
            return Fluids.f_76195_;
        }
        if (fluid instanceof ForgeFlowingFluid) {
            return ((ForgeFlowingFluid)fluid).m_5613_();
        }
        return fluid;
    }

    public static JsonElement serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", RegisteredObjects.getKeyOrThrow(stack.getFluid()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + id + "'");
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        FluidStack stack = new FluidStack(fluid, amount);
        if (!json.has("nbt")) {
            return stack;
        }
        try {
            JsonElement element = json.get("nbt");
            stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? Create.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return stack;
    }

    public static boolean tryEmptyItemIntoBE(Level worldIn, Player player, InteractionHand handIn, ItemStack heldItem, SmartBlockEntity be) {
        if (!GenericItemEmptying.canItemBeEmptied(worldIn, heldItem)) {
            return false;
        }
        Pair<FluidStack, ItemStack> emptyingResult = GenericItemEmptying.emptyItem(worldIn, heldItem, true);
        LazyOptional capability = be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler tank = (IFluidHandler)capability.orElse(null);
        FluidStack fluidStack = emptyingResult.getFirst();
        if (tank == null || fluidStack.getAmount() != tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) {
            return false;
        }
        if (worldIn.f_46443_) {
            return true;
        }
        ItemStack copyOfHeld = heldItem.m_41777_();
        emptyingResult = GenericItemEmptying.emptyItem(worldIn, copyOfHeld, false);
        tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        if (!player.m_7500_() && !(be instanceof CreativeFluidTankBlockEntity)) {
            if (copyOfHeld.m_41619_()) {
                player.m_21008_(handIn, emptyingResult.getSecond());
            } else {
                player.m_21008_(handIn, copyOfHeld);
                player.m_150109_().m_150079_(emptyingResult.getSecond());
            }
        }
        return true;
    }

    public static boolean tryFillItemFromBE(Level world, Player player, InteractionHand handIn, ItemStack heldItem, SmartBlockEntity be) {
        if (!GenericItemFilling.canItemBeFilled(world, heldItem)) {
            return false;
        }
        LazyOptional capability = be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler tank = (IFluidHandler)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            int requiredAmountForItem;
            FluidStack fluid = tank.getFluidInTank(i);
            if (fluid.isEmpty() || (requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem(world, heldItem, fluid.copy())) == -1 || requiredAmountForItem > fluid.getAmount()) continue;
            if (world.f_46443_) {
                return true;
            }
            if (player.m_7500_() || be instanceof CreativeFluidTankBlockEntity) {
                heldItem = heldItem.m_41777_();
            }
            ItemStack out = GenericItemFilling.fillItem(world, requiredAmountForItem, heldItem, fluid.copy());
            FluidStack copy = fluid.copy();
            copy.setAmount(requiredAmountForItem);
            tank.drain(copy, IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_7500_()) {
                player.m_150109_().m_150079_(out);
            }
            be.notifyUpdate();
            return true;
        }
        return false;
    }

    @Nullable
    public static FluidExchange exchange(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred, int maxAmount) {
        return FluidHelper.exchange(fluidTank, fluidItem, preferred, true, maxAmount);
    }

    @Nullable
    public static FluidExchange exchangeAll(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred) {
        return FluidHelper.exchange(fluidTank, fluidItem, preferred, false, Integer.MAX_VALUE);
    }

    @Nullable
    private static FluidExchange exchange(IFluidHandler fluidTank, IFluidHandlerItem fluidItem, FluidExchange preferred, boolean singleOp, int maxTransferAmountPerTank) {
        FluidExchange lockedExchange = null;
        for (int tankSlot = 0; tankSlot < fluidTank.getTanks(); ++tankSlot) {
            for (int slot = 0; slot < fluidItem.getTanks(); ++slot) {
                int amount;
                boolean canMoveToItem;
                FluidStack fluidInTank = fluidTank.getFluidInTank(tankSlot);
                int tankCapacity = fluidTank.getTankCapacity(tankSlot) - fluidInTank.getAmount();
                boolean tankEmpty = fluidInTank.isEmpty();
                FluidStack fluidInItem = fluidItem.getFluidInTank(tankSlot);
                int itemCapacity = fluidItem.getTankCapacity(tankSlot) - fluidInItem.getAmount();
                boolean itemEmpty = fluidInItem.isEmpty();
                boolean undecided = lockedExchange == null;
                boolean canMoveToTank = (undecided || lockedExchange == FluidExchange.ITEM_TO_TANK) && tankCapacity > 0;
                boolean bl = canMoveToItem = (undecided || lockedExchange == FluidExchange.TANK_TO_ITEM) && itemCapacity > 0;
                if (!tankEmpty && !itemEmpty && !fluidInItem.isFluidEqual(fluidInTank)) continue;
                if (((tankEmpty || itemCapacity <= 0) && canMoveToTank || undecided && preferred == FluidExchange.ITEM_TO_TANK) && (amount = fluidTank.fill(fluidItem.drain(Math.min(maxTransferAmountPerTank, tankCapacity), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    lockedExchange = FluidExchange.ITEM_TO_TANK;
                    if (!singleOp) continue;
                    return lockedExchange;
                }
                if ((!itemEmpty && tankCapacity > 0 || !canMoveToItem) && (!undecided || preferred != FluidExchange.TANK_TO_ITEM) || (amount = fluidItem.fill(fluidTank.drain(Math.min(maxTransferAmountPerTank, itemCapacity), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                lockedExchange = FluidExchange.TANK_TO_ITEM;
                if (!singleOp) continue;
                return lockedExchange;
            }
        }
        return null;
    }

    public static enum FluidExchange {
        ITEM_TO_TANK,
        TANK_TO_ITEM;

    }
}

