/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.google.common.base.Predicates;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackPropagator;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import org.jetbrains.annotations.Nullable;

public class TrackBlock
extends Block
implements IBE<TrackBlockEntity>,
IWrenchable,
ITrackBlock,
ISpecialBlockItemRequirement,
ProperWaterloggedBlock {
    public static final EnumProperty<TrackShape> SHAPE = EnumProperty.m_61587_((String)"shape", TrackShape.class);
    public static final BooleanProperty HAS_BE = BooleanProperty.m_61465_((String)"turn");
    protected final TrackMaterial f_60442_;

    public TrackBlock(BlockBehaviour.Properties p_49795_, TrackMaterial material) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)TrackShape.ZO))).m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.f_60442_ = material;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_.m_61104_(new Property[]{SHAPE, HAS_BE, WATERLOGGED}));
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.RAIL;
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new RenderProperties());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState stateForPlacement = this.withWater(super.m_5573_(ctx), ctx);
        if (ctx.m_43723_() == null) {
            return stateForPlacement;
        }
        Vec3 lookAngle = ctx.m_43723_().m_20154_();
        if (Mth.m_14082_((double)(lookAngle = lookAngle.m_82542_(1.0, 0.0, 1.0)).m_82553_(), (double)0.0)) {
            lookAngle = VecHelper.rotate(new Vec3(0.0, 0.0, 1.0), -ctx.m_43723_().m_146908_(), Direction.Axis.Y);
        }
        lookAngle = lookAngle.m_82541_();
        TrackShape best = TrackShape.ZO;
        double bestValue = 3.4028234663852886E38;
        for (TrackShape shape : TrackShape.values()) {
            Vec3 axis;
            double distance;
            if (shape.isJunction() || shape.isPortal() || (distance = Math.min((axis = shape.getAxes().get(0)).m_82557_(lookAngle), axis.m_82541_().m_82490_(-1.0).m_82557_(lookAngle))) > bestValue) continue;
            bestValue = distance;
            best = shape;
        }
        Level level = ctx.m_43725_();
        Vec3 bestAxis = best.getAxes().get(0);
        if (bestAxis.m_82556_() == 1.0) {
            for (boolean neg : Iterate.trueAndFalse) {
                BlockPos offset = ctx.m_8083_().m_141952_((Vec3i)new BlockPos(bestAxis.m_82490_(neg ? -1.0 : 1.0)));
                if (!level.m_8055_(offset).m_60783_((BlockGetter)level, offset, Direction.UP) || level.m_8055_(offset.m_7494_()).m_60783_((BlockGetter)level, offset, Direction.DOWN)) continue;
                if (best == TrackShape.XO) {
                    TrackShape trackShape = best = neg ? TrackShape.AW : TrackShape.AE;
                }
                if (best != TrackShape.ZO) continue;
                best = neg ? TrackShape.AN : TrackShape.AS;
            }
        }
        return (BlockState)stateForPlacement.m_61124_(SHAPE, (Comparable)((Object)best));
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pLevel.m_5776_()) {
            return;
        }
        if (!pPlayer.m_7500_()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> {
            be.cancelDrops = true;
            be.removeInboundConnections(true);
        });
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == this && pState.m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(true)) == pOldState.m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(true))) {
            return;
        }
        if (pLevel.f_46443_) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.m_183326_();
        if (!blockTicks.m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
        this.updateGirders(pState, pLevel, pPos, (LevelTickAccess<Block>)blockTicks);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, TrackBlockEntity::validateConnections);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random p_60465_) {
        TrackPropagator.onRailAdded((LevelAccessor)level, pos, state);
        this.withBlockEntityDo((BlockGetter)level, pos, tbe -> tbe.tilt.undoSmoothing());
        if (!((TrackShape)((Object)state.m_61143_(SHAPE))).isPortal()) {
            this.connectToNether(level, pos, state);
        }
    }

    protected void connectToNether(ServerLevel level, BlockPos pos, BlockState state) {
        Direction.Axis portalTest;
        TrackShape shape = (TrackShape)((Object)state.m_61143_(SHAPE));
        Object object = shape == TrackShape.XO ? Direction.Axis.X : (portalTest = shape == TrackShape.ZO ? Direction.Axis.Z : null);
        if (portalTest == null) {
            return;
        }
        boolean pop = false;
        String fail = null;
        BlockPos failPos = null;
        for (Direction d : Iterate.directionsInAxis(portalTest)) {
            BlockFace otherTrack;
            BlockPos otherTrackPos;
            BlockPos portalPos = pos.m_142300_(d);
            BlockState portalState = level.m_8055_(portalPos);
            if (!(portalState.m_60734_() instanceof NetherPortalBlock)) continue;
            pop = true;
            Pair<ServerLevel, BlockFace> otherSide = this.getOtherSide(level, new BlockFace(pos, d));
            if (otherSide == null) {
                fail = "missing";
                continue;
            }
            ServerLevel otherLevel = otherSide.getFirst();
            BlockState existing = otherLevel.m_8055_(otherTrackPos = (otherTrack = otherSide.getSecond()).getPos());
            if (!existing.m_60767_().m_76336_()) {
                fail = "blocked";
                failPos = otherTrackPos;
                continue;
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)((Object)TrackShape.asPortal(d)))).m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)be;
                tbe.bind((ResourceKey<Level>)otherLevel.m_46472_(), otherTrackPos);
            }
            otherLevel.m_7731_(otherTrackPos, (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)((Object)TrackShape.asPortal(otherTrack.getFace())))).m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            BlockEntity otherBE = otherLevel.m_7702_(otherTrackPos);
            if (otherBE instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)otherBE;
                tbe.bind((ResourceKey<Level>)level.m_46472_(), pos);
            }
            pop = false;
        }
        if (!pop) {
            return;
        }
        level.m_46961_(pos, true);
        if (fail == null) {
            return;
        }
        Player player = level.m_5788_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10.0, (Predicate)Predicates.alwaysTrue());
        if (player == null) {
            return;
        }
        player.m_5661_((Component)Components.literal("<!> ").m_7220_((Component)Lang.translateDirect("portal_track.failed", new Object[0])).m_130940_(ChatFormatting.GOLD), false);
        MutableComponent component = failPos != null ? Lang.translateDirect("portal_track." + fail, failPos.m_123341_(), failPos.m_123342_(), failPos.m_123343_()) : Lang.translateDirect("portal_track." + fail, new Object[0]);
        player.m_5661_((Component)Components.literal(" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)component.m_130938_(st -> st.m_178520_(16765876))), false);
    }

    protected Pair<ServerLevel, BlockFace> getOtherSide(ServerLevel level, BlockFace inboundTrack) {
        ResourceKey resourcekey;
        BlockPos portalPos = inboundTrack.getConnectedPos();
        BlockState portalState = level.m_8055_(portalPos);
        if (!(portalState.m_60734_() instanceof NetherPortalBlock)) {
            return null;
        }
        MinecraftServer minecraftserver = level.m_142572_();
        ServerLevel otherLevel = minecraftserver.m_129880_(resourcekey = level.m_46472_() == Level.f_46429_ ? Level.f_46428_ : Level.f_46429_);
        if (otherLevel == null || !minecraftserver.m_7079_()) {
            return null;
        }
        PortalForcer teleporter = otherLevel.m_8871_();
        SuperGlueEntity probe = new SuperGlueEntity((Level)level, new AABB(portalPos));
        probe.m_146922_(inboundTrack.getFace().m_122435_());
        PortalInfo portalinfo = teleporter.getPortalInfo((Entity)probe, otherLevel, probe::m_7937_);
        if (portalinfo == null) {
            return null;
        }
        BlockPos otherPortalPos = new BlockPos(portalinfo.f_77676_);
        BlockState otherPortalState = otherLevel.m_8055_(otherPortalPos);
        if (!(otherPortalState.m_60734_() instanceof NetherPortalBlock)) {
            return null;
        }
        Direction targetDirection = inboundTrack.getFace();
        if (targetDirection.m_122434_() == otherPortalState.m_61143_((Property)NetherPortalBlock.f_54904_)) {
            targetDirection = targetDirection.m_122427_();
        }
        BlockPos otherPos = otherPortalPos.m_142300_(targetDirection);
        return Pair.of(otherLevel, new BlockFace(otherPos, targetDirection.m_122424_()));
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(level, state, pCurrentPos);
        TrackShape shape = (TrackShape)((Object)state.m_61143_(SHAPE));
        if (!shape.isPortal()) {
            return state;
        }
        for (Direction d : Iterate.horizontalDirections) {
            BlockPos portalPos;
            BlockState portalState;
            if (TrackShape.asPortal(d) != state.m_61143_(SHAPE) || pDirection != d || (portalState = level.m_8055_(portalPos = pCurrentPos.m_142300_(d))).m_60734_() instanceof NetherPortalBlock) continue;
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public int getYOffsetAt(BlockGetter world, BlockPos pos, BlockState state, Vec3 end) {
        return this.getBlockEntityOptional(world, pos).map(tbe -> tbe.tilt.getYOffsetForAxisEnd(end)).orElse(0);
    }

    @Override
    public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(BlockGetter worldIn, BlockPos pos, BlockState state, boolean linear, TrackNodeLocation connectedTo) {
        Collection<TrackNodeLocation.DiscoveredLocation> list;
        BlockGetter world;
        if (connectedTo != null && worldIn instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)worldIn;
            v0 = sl.m_142572_().m_129880_(connectedTo.dimension);
        } else {
            v0 = world = worldIn;
        }
        if (this.getTrackAxes(world, pos, state).size() > 1) {
            Vec3 center = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
            TrackShape shape = (TrackShape)((Object)state.m_61143_(SHAPE));
            list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
            for (Vec3 axis2 : this.getTrackAxes(world, pos, state)) {
                for (boolean fromCenter : Iterate.trueAndFalse) {
                    ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> axis2.m_82490_(b != false ? 0.0 : (fromCenter ? -d.doubleValue() : d)).m_82549_(center), b -> shape.getNormal(), b -> {
                        ResourceKey resourceKey;
                        if (world instanceof Level) {
                            Level l = (Level)world;
                            resourceKey = l.m_46472_();
                        } else {
                            resourceKey = Level.f_46428_;
                        }
                        return resourceKey;
                    }, v -> 0, axis2, null, (b, v) -> ITrackBlock.getMaterialSimple(world, v));
                }
            }
        } else {
            list = ITrackBlock.super.getConnected(world, pos, state, linear, connectedTo);
        }
        if (!((Boolean)state.m_61143_((Property)HAS_BE)).booleanValue()) {
            return list;
        }
        if (linear) {
            return list;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof TrackBlockEntity)) {
            return list;
        }
        TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
        Map<BlockPos, BezierConnection> connections = trackBE.getConnections();
        connections.forEach((connectedPos, bc) -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> d == 1.0 ? Vec3.m_82528_((Vec3i)((Vec3i)bc.tePositions.get((boolean)b))) : bc.starts.get((boolean)b), bc.normals::get, b -> {
            ResourceKey resourceKey;
            if (world instanceof Level) {
                Level l = (Level)world;
                resourceKey = l.m_46472_();
            } else {
                resourceKey = Level.f_46428_;
            }
            return resourceKey;
        }, bc::yOffsetAt, null, bc, (b, v) -> ITrackBlock.getMaterialSimple(world, v, bc.getMaterial())));
        if (trackBE.boundLocation == null || !(world instanceof ServerLevel)) {
            return list;
        }
        ServerLevel level = (ServerLevel)world;
        ResourceKey<Level> otherDim = trackBE.boundLocation.getFirst();
        ServerLevel otherLevel = level.m_142572_().m_129880_(otherDim);
        if (otherLevel == null) {
            return list;
        }
        BlockPos boundPos = trackBE.boundLocation.getSecond();
        BlockState boundState = otherLevel.m_8055_(boundPos);
        if (!AllTags.AllBlockTags.TRACKS.matches(boundState)) {
            return list;
        }
        Vec3 center = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
        Vec3 boundCenter = Vec3.m_82539_((Vec3i)boundPos).m_82520_(0.0, this.getElevationAtCenter((BlockGetter)otherLevel, boundPos, boundState), 0.0);
        TrackShape shape = (TrackShape)((Object)state.m_61143_(SHAPE));
        TrackShape boundShape = (TrackShape)((Object)boundState.m_61143_(SHAPE));
        Vec3 boundAxis = this.getTrackAxes((BlockGetter)otherLevel, boundPos, boundState).get(0);
        this.getTrackAxes(world, pos, state).forEach(axis -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> (b != false ? axis : boundAxis).m_82490_(d.doubleValue()).m_82549_(b != false ? center : boundCenter), b -> (b != false ? shape : boundShape).getNormal(), b -> b != false ? level.m_46472_() : otherLevel.m_46472_(), v -> 0, axis, null, (b, v) -> ITrackBlock.getMaterialSimple((BlockGetter)(b != false ? level : otherLevel), v)));
        return list;
    }

    public void m_7100_(BlockState pState, Level pLevel, BlockPos pPos, Random pRand) {
        if (!((TrackShape)((Object)pState.m_61143_(SHAPE))).isPortal()) {
            return;
        }
        Vec3 v = Vec3.m_82528_((Vec3i)pPos).m_82492_(0.125, 0.0, 0.125);
        CubeParticleData data = new CubeParticleData(1.0f, pRand.nextFloat(), 1.0f, 0.0125f + 0.0625f * pRand.nextFloat(), 30, false);
        pLevel.m_7106_((ParticleOptions)data, v.f_82479_ + (double)(pRand.nextFloat() * 1.5f), v.f_82480_ + 0.25, v.f_82481_ + (double)(pRand.nextFloat() * 1.5f), 0.0, 0.04, 0.0);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        boolean removeBE = false;
        if (!(!((Boolean)pState.m_61143_((Property)HAS_BE)).booleanValue() || pState.m_60713_(pNewState.m_60734_()) && ((Boolean)pNewState.m_61143_((Property)HAS_BE)).booleanValue())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
                if (!pLevel.f_46443_) {
                    tbe.cancelDrops = tbe.cancelDrops | pNewState.m_60734_() == this;
                    tbe.removeInboundConnections(true);
                }
            }
            removeBE = true;
        }
        if (pNewState.m_60734_() != this || pState.m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(true)) != pNewState.m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(true))) {
            TrackPropagator.onRailRemoved((LevelAccessor)pLevel, pPos, pState);
        }
        if (removeBE) {
            pLevel.m_46747_(pPos);
        }
        if (!pLevel.f_46443_) {
            this.updateGirders(pState, pLevel, pPos, (LevelTickAccess<Block>)pLevel.m_183326_());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        for (Map.Entry<BlockPos, BoundingBox> entry : StationBlockEntity.assemblyAreas.get((LevelAccessor)world).entrySet()) {
            StationBlockEntity station;
            BlockEntity blockEntity;
            if (!entry.getValue().m_71051_((Vec3i)pos) || !((blockEntity = world.m_7702_(entry.getKey())) instanceof StationBlockEntity) || !(station = (StationBlockEntity)blockEntity).trackClicked(player, hand, this, state, pos)) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void updateGirders(BlockState pState, Level pLevel, BlockPos pPos, LevelTickAccess<Block> blockTicks) {
        for (Vec3 vec3 : this.getTrackAxes((BlockGetter)pLevel, pPos, pState)) {
            if (vec3.m_82553_() > 1.0 || vec3.f_82480_ != 0.0) continue;
            for (int side : Iterate.positiveAndNegative) {
                GirderBlock girderBlock;
                BlockPos girderPos = pPos.m_7495_().m_142022_(vec3.f_82481_ * (double)side, 0.0, vec3.f_82479_ * (double)side);
                BlockState girderState = pLevel.m_8055_(girderPos);
                Block block = girderState.m_60734_();
                if (!(block instanceof GirderBlock) || blockTicks.m_183582_(girderPos, (Object)(girderBlock = (GirderBlock)block))) continue;
                pLevel.m_186460_(girderPos, (Block)girderBlock, 1);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_8055_(pos.m_7495_()).m_60734_() != this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.getFullShape(state);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter pLevel, BlockPos pPos) {
        return this.getFullShape(state);
    }

    private VoxelShape getFullShape(BlockState state) {
        switch ((TrackShape)((Object)state.m_61143_(SHAPE))) {
            case AE: {
                return AllShapes.TRACK_ASC.get(Direction.EAST);
            }
            case AW: {
                return AllShapes.TRACK_ASC.get(Direction.WEST);
            }
            case AN: {
                return AllShapes.TRACK_ASC.get(Direction.NORTH);
            }
            case AS: {
                return AllShapes.TRACK_ASC.get(Direction.SOUTH);
            }
            case CR_D: {
                return AllShapes.TRACK_CROSS_DIAG;
            }
            case CR_NDX: {
                return AllShapes.TRACK_CROSS_ORTHO_DIAG.get(Direction.SOUTH);
            }
            case CR_NDZ: {
                return AllShapes.TRACK_CROSS_DIAG_ORTHO.get(Direction.SOUTH);
            }
            case CR_O: {
                return AllShapes.TRACK_CROSS;
            }
            case CR_PDX: {
                return AllShapes.TRACK_CROSS_DIAG_ORTHO.get(Direction.EAST);
            }
            case CR_PDZ: {
                return AllShapes.TRACK_CROSS_ORTHO_DIAG.get(Direction.EAST);
            }
            case ND: {
                return AllShapes.TRACK_DIAG.get(Direction.SOUTH);
            }
            case PD: {
                return AllShapes.TRACK_DIAG.get(Direction.EAST);
            }
            case XO: {
                return AllShapes.TRACK_ORTHO.get(Direction.EAST);
            }
            case ZO: {
                return AllShapes.TRACK_ORTHO.get(Direction.SOUTH);
            }
            case TE: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.EAST);
            }
            case TW: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.WEST);
            }
            case TS: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.SOUTH);
            }
            case TN: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.NORTH);
            }
        }
        return AllShapes.TRACK_FALLBACK;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((TrackShape)((Object)pState.m_61143_(SHAPE))) {
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                return Shapes.m_83040_();
            }
        }
        return AllShapes.TRACK_COLLISION;
    }

    @Override
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)HAS_BE)).booleanValue()) {
            return null;
        }
        return AllBlockEntityTypes.TRACK.create(p_153215_, state);
    }

    @Override
    public Class<TrackBlockEntity> getBlockEntityClass() {
        return TrackBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends TrackBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.TRACK.get();
    }

    @Override
    public Vec3 getUpNormal(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TrackShape)((Object)state.m_61143_(SHAPE))).getNormal();
    }

    @Override
    public List<Vec3> getTrackAxes(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TrackShape)((Object)state.m_61143_(SHAPE))).getAxes();
    }

    @Override
    public Vec3 getCurveStart(BlockGetter world, BlockPos pos, BlockState state, Vec3 axis) {
        boolean vertical = axis.f_82480_ != 0.0;
        return VecHelper.getCenterOf((Vec3i)pos).m_82520_(0.0, (double)(vertical ? 0.0f : -0.5f), 0.0).m_82549_(axis.m_82490_(0.5));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        if (!level.f_46443_ && !player.m_7500_() && ((Boolean)state.m_61143_((Property)HAS_BE)).booleanValue() && (blockEntity = level.m_7702_(context.m_8083_())) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
            trackBE.cancelDrops = true;
            trackBE.connections.values().forEach(bc -> bc.addItemsToPlayer(player));
        }
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public BlockState overlay(BlockGetter world, BlockPos pos, BlockState existing, BlockState placed) {
        if (placed.m_60734_() != this) {
            return existing;
        }
        TrackShape existingShape = (TrackShape)((Object)existing.m_61143_(SHAPE));
        TrackShape placedShape = (TrackShape)((Object)placed.m_61143_(SHAPE));
        TrackShape combinedShape = null;
        for (boolean flip : Iterate.trueAndFalse) {
            TrackShape s2;
            TrackShape s1 = flip ? existingShape : placedShape;
            TrackShape trackShape = s2 = flip ? placedShape : existingShape;
            if (s1 == TrackShape.XO && s2 == TrackShape.ZO) {
                combinedShape = TrackShape.CR_O;
            }
            if (s1 == TrackShape.PD && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_D;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDX;
            }
            if (s1 == TrackShape.ZO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDZ;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_NDX;
            }
            if (s1 != TrackShape.ZO || s2 != TrackShape.ND) continue;
            combinedShape = TrackShape.CR_NDZ;
        }
        if (combinedShape != null) {
            existing = (BlockState)existing.m_61124_(SHAPE, combinedShape);
        }
        return existing;
    }

    public BlockState m_6843_(BlockState state, Rotation pRotation) {
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.m_61143_(SHAPE))).rotate(pRotation)));
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.m_61143_(SHAPE))).mirror(pMirror)));
    }

    @Override
    public BlockState getBogeyAnchor(BlockGetter world, BlockPos pos, BlockState state) {
        return (BlockState)AllBlocks.SMALL_BOGEY.getDefaultState().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)(state.m_61143_(SHAPE) == TrackShape.XO ? Direction.Axis.X : Direction.Axis.Z));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel prepareAssemblyOverlay(BlockGetter world, BlockPos pos, BlockState state, Direction direction, PoseStack ms) {
        TransformStack.cast((PoseStack)ms).rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(direction)));
        return AllPartialModels.TRACK_ASSEMBLING_OVERLAY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel prepareTrackOverlay(BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, PoseStack ms, TrackTargetingBehaviour.RenderedTrackOverlayType type) {
        TrackBlockEntity trackTE;
        BlockEntity length2;
        BlockEntity blockEntity;
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        Vec3 axis = null;
        Vec3 diff = null;
        Vec3 normal = null;
        Vec3 offset = null;
        if (bezierPoint != null && (blockEntity = world.m_7702_(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
            BezierConnection bc = trackBE.connections.get(bezierPoint.curveTarget());
            if (bc != null) {
                double length2 = Mth.m_14107_((double)(bc.getLength() * 2.0));
                int seg = bezierPoint.segment() + 1;
                double t = (double)seg / length2;
                double tpre = (double)(seg - 1) / length2;
                double tpost = (double)(seg + 1) / length2;
                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).m_82546_(bc.getPosition(tpre)).m_82541_();
                msr.translate(offset.m_82546_(Vec3.m_82539_((Vec3i)pos)));
                msr.translate(0.0, -0.25, 0.0);
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)state.m_61143_(SHAPE))).getAxes().get(0);
            diff = axis.m_82490_((double)direction.m_122540_()).m_82541_();
            normal = this.getUpNormal(world, pos, state);
        }
        Vec3 angles = TrackRenderer.getModelAngles(normal, diff);
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateYRadians(angles.f_82480_)).rotateXRadians(angles.f_82479_)).unCentre();
        if (axis != null) {
            msr.translate(0.0, axis.f_82480_ != 0.0 ? 0.4375 : 0.0, axis.f_82480_ != 0.0 ? (double)((float)direction.m_122540_() * 2.5f / 16.0f) : 0.0);
        } else {
            msr.translate(0.0, 0.25, 0.0);
            if (direction == Direction.AxisDirection.NEGATIVE) {
                msr.rotateCentered(Direction.UP, (float)Math.PI);
            }
        }
        if (bezierPoint == null && (length2 = world.m_7702_(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)length2).isTilted()) {
            double yOffset = 0.0;
            for (BezierConnection bc : trackTE.connections.values()) {
                yOffset += ((Vec3)bc.starts.getFirst()).f_82480_ - (double)pos.m_123342_();
            }
            ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateX((double)(-direction.m_122540_()) * trackTE.tilt.smoothingAngle.get())).unCentre()).translate(0.0, yOffset / 2.0, 0.0);
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL -> AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER -> AllPartialModels.TRACK_OBSERVER_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL -> AllPartialModels.TRACK_SIGNAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.STATION -> AllPartialModels.TRACK_STATION_OVERLAY;
        };
    }

    @Override
    public boolean trackEquals(BlockState state1, BlockState state2) {
        return state1.m_60734_() == this && state2.m_60734_() == this && state1.m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(false)) == state2.m_61124_((Property)HAS_BE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        int sameTypeTrackAmount = 1;
        Object2IntArrayMap otherTrackAmounts = new Object2IntArrayMap();
        int girderAmount = 0;
        if (be instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)be;
            for (BezierConnection bezierConnection : track.getConnections().values()) {
                if (!bezierConnection.isPrimary()) continue;
                TrackMaterial material = bezierConnection.getMaterial();
                if (material == this.getMaterial()) {
                    sameTypeTrackAmount += bezierConnection.getTrackItemCost();
                } else {
                    otherTrackAmounts.put((Object)material, otherTrackAmounts.getOrDefault((Object)material, 0) + 1);
                }
                girderAmount += bezierConnection.getGirderItemCost();
            }
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        while (sameTypeTrackAmount > 0) {
            stacks.add(new ItemStack((ItemLike)state.m_60734_(), Math.min(sameTypeTrackAmount, 64)));
            sameTypeTrackAmount -= 64;
        }
        for (TrackMaterial material : otherTrackAmounts.keySet()) {
            for (int amt = otherTrackAmounts.getOrDefault((Object)material, 0); amt > 0; amt -= 64) {
                stacks.add(material.asStack(Math.min(amt, 64)));
            }
        }
        while (girderAmount > 0) {
            stacks.add(AllBlocks.METAL_GIRDER.asStack(Math.min(girderAmount, 64)));
            girderAmount -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Override
    public TrackMaterial getMaterial() {
        return this.f_60442_;
    }

    public static class RenderProperties
    extends ReducedDestroyEffects
    implements MultiPosDestructionHandler {
        @Override
        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TrackBlockEntity) {
                TrackBlockEntity track = (TrackBlockEntity)blockEntity;
                return new HashSet<BlockPos>(track.connections.keySet());
            }
            return null;
        }
    }
}

