/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ScheduleItemEntityInteraction {
    @SubscribeEvent
    public static void interactWithConductor(PlayerInteractEvent.EntityInteractSpecific event) {
        boolean onServer;
        ScheduleItem si;
        InteractionResult result;
        Entity entity = event.getTarget();
        Player player = event.getPlayer();
        if (player == null || entity == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        Entity rootVehicle = entity.m_20201_();
        if (!(rootVehicle instanceof CarriageContraptionEntity)) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (player.m_36335_().m_41519_((Item)AllItems.SCHEDULE.get())) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        if (item instanceof ScheduleItem && (result = (si = (ScheduleItem)item).handScheduleTo(itemStack, player, living, event.getHand())).m_19077_()) {
            player.m_36335_().m_41524_((Item)AllItems.SCHEDULE.get(), 5);
            event.setCancellationResult(result);
            event.setCanceled(true);
            return;
        }
        if (event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)rootVehicle;
        Contraption contraption = cce.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        Train train = cce.getCarriage().train;
        if (train == null) {
            return;
        }
        if (train.runtime.getSchedule() == null) {
            return;
        }
        Integer seatIndex = contraption.getSeatMapping().get(entity.m_142081_());
        if (seatIndex == null) {
            return;
        }
        BlockPos seatPos = contraption.getSeats().get(seatIndex);
        Couple<Boolean> directions = cc.conductorSeats.get(seatPos);
        if (directions == null) {
            return;
        }
        boolean bl = onServer = !event.getWorld().f_46443_;
        if (train.runtime.paused && !train.runtime.completed) {
            if (onServer) {
                train.runtime.paused = false;
                AllSoundEvents.CONFIRM.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
                player.m_5661_((Component)Lang.translateDirect("schedule.continued", new Object[0]), true);
            }
            player.m_36335_().m_41524_((Item)AllItems.SCHEDULE.get(), 5);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        ItemStack itemInHand = player.m_21120_(event.getHand());
        if (!itemInHand.m_41619_()) {
            if (onServer) {
                AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
                player.m_5661_((Component)Lang.translateDirect("schedule.remove_with_empty_hand", new Object[0]), true);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (onServer) {
            AllSoundEvents.playItemPickup(player);
            player.m_5661_((Component)Lang.translateDirect(train.runtime.isAutoSchedule ? "schedule.auto_removed_from_train" : "schedule.removed_from_train", new Object[0]), true);
            player.m_150109_().m_150079_(train.runtime.returnSchedule());
        }
        player.m_36335_().m_41524_((Item)AllItems.SCHEDULE.get(), 5);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

