/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.analogLever;

import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnalogLeverBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IBE<AnalogLeverBlockEntity> {
    public AnalogLeverBlock(BlockBehaviour.Properties p_i48402_1_) {
        super(p_i48402_1_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            AnalogLeverBlock.addParticles(state, (LevelAccessor)worldIn, pos, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            boolean sneak = player.m_6144_();
            be.changeState(sneak);
            float f = 0.25f + (float)(be.state + 5) / 15.0f * 0.5f;
            worldIn.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.2f, f);
            return InteractionResult.SUCCESS;
        });
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.getBlockEntityOptional(blockAccess, pos).map(al -> al.state).orElse(0);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return AnalogLeverBlock.m_53200_((BlockState)blockState) == side ? this.m_6378_(blockState, blockAccess, pos, side) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.state != 0 && rand.nextFloat() < 0.25f) {
                AnalogLeverBlock.addParticles(stateIn, (LevelAccessor)worldIn, pos, 0.5f);
            }
        });
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (isMoving || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.state != 0) {
                AnalogLeverBlock.updateNeighbors(state, worldIn, pos);
            }
            worldIn.m_46747_(pos);
        });
    }

    private static void addParticles(BlockState state, LevelAccessor worldIn, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        Direction direction1 = AnalogLeverBlock.m_53200_((BlockState)state).m_122424_();
        double d0 = (double)pos.m_123341_() + 0.5 + 0.1 * (double)direction.m_122429_() + 0.2 * (double)direction1.m_122429_();
        double d1 = (double)pos.m_123342_() + 0.5 + 0.1 * (double)direction.m_122430_() + 0.2 * (double)direction1.m_122430_();
        double d2 = (double)pos.m_123343_() + 0.5 + 0.1 * (double)direction.m_122431_() + 0.2 * (double)direction1.m_122431_();
        worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), alpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    static void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, state.m_60734_());
        world.m_46672_(pos.m_142300_(AnalogLeverBlock.m_53200_((BlockState)state).m_122424_()), state.m_60734_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Blocks.f_50164_.m_5940_(state, worldIn, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{f_54117_, f_53179_}));
    }

    @Override
    public Class<AnalogLeverBlockEntity> getBlockEntityClass() {
        return AnalogLeverBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends AnalogLeverBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.ANALOG_LEVER.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

