/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.burner;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BlazeBurnerInteractionBehaviour
extends MovingInteractionBehaviour {
    @Override
    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos localPos, AbstractContraptionEntity contraptionEntity) {
        ItemStack itemInHand = player.m_21120_(activeHand);
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return false;
        }
        CarriageContraptionEntity carriageEntity = (CarriageContraptionEntity)contraptionEntity;
        if (activeHand == InteractionHand.OFF_HAND) {
            return false;
        }
        Contraption contraption = carriageEntity.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        StructureTemplate.StructureBlockInfo info = carriageContraption.getBlocks().get(localPos);
        if (info == null || !info.f_74676_.m_61138_(BlazeBurnerBlock.HEAT_LEVEL) || info.f_74676_.m_61143_(BlazeBurnerBlock.HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.NONE) {
            return false;
        }
        Direction assemblyDirection = carriageContraption.getAssemblyDirection();
        for (Direction direction : Iterate.directionsInAxis(assemblyDirection.m_122434_())) {
            if (!carriageContraption.inControl(localPos, direction)) continue;
            Train train = carriageEntity.getCarriage().train;
            if (train == null) {
                return false;
            }
            if (player.f_19853_.f_46443_) {
                return true;
            }
            if (train.runtime.getSchedule() != null) {
                if (train.runtime.paused && !train.runtime.completed) {
                    train.runtime.paused = false;
                    AllSoundEvents.CONFIRM.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
                    player.m_5661_((Component)Lang.translateDirect("schedule.continued", new Object[0]), true);
                    return true;
                }
                if (!itemInHand.m_41619_()) {
                    AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
                    player.m_5661_((Component)Lang.translateDirect("schedule.remove_with_empty_hand", new Object[0]), true);
                    return true;
                }
                AllSoundEvents.playItemPickup(player);
                player.m_5661_((Component)Lang.translateDirect(train.runtime.isAutoSchedule ? "schedule.auto_removed_from_train" : "schedule.removed_from_train", new Object[0]), true);
                player.m_21008_(activeHand, train.runtime.returnSchedule());
                return true;
            }
            if (!AllItems.SCHEDULE.isIn(itemInHand)) {
                return true;
            }
            Schedule schedule = ScheduleItem.getSchedule(itemInHand);
            if (schedule == null) {
                return false;
            }
            if (schedule.entries.isEmpty()) {
                AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
                player.m_5661_((Component)Lang.translateDirect("schedule.no_stops", new Object[0]), true);
                return true;
            }
            train.runtime.setSchedule(schedule, false);
            AllAdvancements.CONDUCTOR.awardTo(player);
            AllSoundEvents.CONFIRM.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
            player.m_5661_((Component)Lang.translateDirect("schedule.applied_to_train", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
            itemInHand.m_41774_(1);
            player.m_21008_(activeHand, itemInHand.m_41619_() ? ItemStack.f_41583_ : itemInHand);
            return true;
        }
        player.m_5661_((Component)Lang.translateDirect("schedule.non_controlling_seat", new Object[0]), true);
        AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
        return true;
    }
}

