/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tunnel;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.TunnelFlapPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BeltTunnelBlockEntity
extends SmartBlockEntity {
    public Map<Direction, LerpedFloat> flaps;
    public Set<Direction> sides;
    protected LazyOptional<IItemHandler> cap = LazyOptional.empty();
    protected List<Pair<Direction, Boolean>> flapsToSend;

    public BeltTunnelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.flaps = new EnumMap<Direction, LerpedFloat>(Direction.class);
        this.sides = new HashSet<Direction>();
        this.flapsToSend = new LinkedList<Pair<Direction, Boolean>>();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cap.invalidate();
    }

    protected void writeFlapsAndSides(CompoundTag compound) {
        ListTag flapsNBT = new ListTag();
        for (Direction direction : this.flaps.keySet()) {
            flapsNBT.add((Object)IntTag.m_128679_((int)direction.m_122411_()));
        }
        compound.m_128365_("Flaps", (Tag)flapsNBT);
        ListTag sidesNBT = new ListTag();
        for (Direction direction : this.sides) {
            sidesNBT.add((Object)IntTag.m_128679_((int)direction.m_122411_()));
        }
        compound.m_128365_("Sides", (Tag)sidesNBT);
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        this.writeFlapsAndSides(tag);
        super.writeSafe(tag);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        this.writeFlapsAndSides(compound);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        HashSet<Direction> newFlaps = new HashSet<Direction>(6);
        ListTag flapsNBT = compound.m_128437_("Flaps", 3);
        for (Tag inbt : flapsNBT) {
            if (!(inbt instanceof IntTag)) continue;
            newFlaps.add(Direction.m_122376_((int)((IntTag)inbt).m_7047_()));
        }
        this.sides.clear();
        ListTag sidesNBT = compound.m_128437_("Sides", 3);
        for (Tag inbt : sidesNBT) {
            if (!(inbt instanceof IntTag)) continue;
            this.sides.add(Direction.m_122376_((int)((IntTag)inbt).m_7047_()));
        }
        for (Direction d : Iterate.directions) {
            if (!newFlaps.contains(d)) {
                this.flaps.remove(d);
                continue;
            }
            if (this.flaps.containsKey(d)) continue;
            this.flaps.put(d, this.createChasingFlap());
        }
        if (!compound.m_128441_("Sides") && compound.m_128441_("Flaps")) {
            this.sides.addAll(this.flaps.keySet());
        }
        super.read(compound, clientPacket);
        if (clientPacket) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)this));
        }
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, 0.05f, LerpedFloat.Chaser.EXP);
    }

    public void updateTunnelConnections() {
        this.flaps.clear();
        this.sides.clear();
        BlockState tunnelState = this.m_58900_();
        for (Direction direction : Iterate.horizontalDirections) {
            if (direction.m_122434_() != tunnelState.m_61143_((Property)BlockStateProperties.f_61364_)) {
                boolean positive = direction.m_122421_() == Direction.AxisDirection.POSITIVE ^ direction.m_122434_() == Direction.Axis.Z;
                BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)tunnelState.m_61143_(BeltTunnelBlock.SHAPE));
                if (BeltTunnelBlock.isStraight(tunnelState) || positive && shape == BeltTunnelBlock.Shape.T_LEFT || !positive && shape == BeltTunnelBlock.Shape.T_RIGHT) continue;
            }
            this.sides.add(direction);
            BlockState nextState = this.f_58857_.m_8055_(this.f_58858_.m_142300_(direction));
            if (nextState.m_60734_() instanceof BeltTunnelBlock || nextState.m_60734_() instanceof BeltFunnelBlock && nextState.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && nextState.m_61143_((Property)BeltFunnelBlock.HORIZONTAL_FACING) == direction.m_122424_()) continue;
            this.flaps.put(direction, this.createChasingFlap());
        }
        this.sendData();
    }

    public void flap(Direction side, boolean inward) {
        if (this.f_58857_.f_46443_) {
            if (this.flaps.containsKey(side)) {
                this.flaps.get(side).setValue(inward ^ side.m_122434_() == Direction.Axis.Z ? -1.0 : 1.0);
            }
            return;
        }
        this.flapsToSend.add((Pair<Direction, Boolean>)Pair.of((Object)side, (Object)inward));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateTunnelConnections();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            if (!this.flapsToSend.isEmpty()) {
                this.sendFlaps();
            }
            return;
        }
        this.flaps.forEach((d, value) -> value.tickChaser());
    }

    private void sendFlaps() {
        AllPackets.getChannel().send(this.packetTarget(), (Object)new TunnelFlapPacket(this, this.flapsToSend));
        this.flapsToSend.clear();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        Object capBelow;
        BlockEntity teBelow;
        if (capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(capability, side);
        }
        if (!this.cap.isPresent() && AllBlocks.BELT.has(this.f_58857_.m_8055_(this.f_58858_.m_7495_())) && (teBelow = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) != null && (capBelow = teBelow.getCapability(capability, Direction.UP).orElse(null)) != null) {
            this.cap = LazyOptional.of(() -> capBelow).cast();
        }
        return this.cap.cast();
    }
}

