/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorFloorListPacket;
import com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ElevatorPulleyBlockEntity
extends PulleyBlockEntity {
    private float prevSpeed = 0.0f;
    private boolean arrived = true;
    private int clientOffsetTarget;
    private boolean initialOffsetReceived = false;

    public ElevatorPulleyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private int getTargetOffset() {
        Contraption contraption;
        if (this.f_58857_.f_46443_) {
            return this.clientOffsetTarget;
        }
        if (this.movedContraption == null || !((contraption = this.movedContraption.getContraption()) instanceof ElevatorContraption)) {
            return (int)this.offset;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        Integer target = ec.getCurrentTargetY(this.f_58857_);
        if (target == null) {
            return (int)this.offset;
        }
        return this.f_58858_.m_123342_() - target + ec.contactYOffset - 1;
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        super.attach(contraption);
        if (this.offset >= 0.0f) {
            this.resetContraptionToOffset();
        }
        if (this.f_58857_.f_46443_) {
            AllPackets.getChannel().sendToServer((Object)new ElevatorFloorListPacket.RequestFloorList(contraption));
            return;
        }
        Contraption contraption2 = contraption.getContraption();
        if (contraption2 instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption2;
            ElevatorColumn.getOrCreate((LevelAccessor)this.f_58857_, ec.getGlobalColumn()).setActive(true);
        }
    }

    @Override
    public void tick() {
        double diff;
        boolean wasArrived = this.arrived;
        super.tick();
        if (this.movedContraption == null) {
            return;
        }
        Contraption contraption = this.movedContraption.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        if (this.f_58857_.m_5776_()) {
            ec.setClientYTarget(this.f_58858_.m_123342_() - this.clientOffsetTarget + ec.contactYOffset - 1);
        }
        this.waitingForSpeedChange = false;
        ec.arrived = wasArrived;
        if (!this.arrived) {
            return;
        }
        double y = this.movedContraption.m_20186_();
        int targetLevel = Mth.m_14107_((double)(0.5 + y)) + ec.contactYOffset;
        Integer ecCurrentTargetY = ec.getCurrentTargetY(this.f_58857_);
        if (ecCurrentTargetY != null) {
            targetLevel = ecCurrentTargetY;
        }
        if (this.f_58857_.m_5776_()) {
            targetLevel = ec.clientYTarget;
        }
        if (!wasArrived && !this.f_58857_.m_5776_()) {
            this.triggerContact(ec, targetLevel - ec.contactYOffset);
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.play(this.f_58857_, null, (Vec3i)this.f_58858_.m_6625_((int)this.offset), 0.75f, 0.8f);
        }
        if (Math.abs(diff = (double)targetLevel - y - (double)ec.contactYOffset) > 0.0078125) {
            diff *= 0.25;
        }
        this.movedContraption.m_146884_(this.movedContraption.m_20182_().m_82520_(0.0, diff, 0.0));
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.m_5776_() || !this.arrived) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.m_6084_()) {
            return;
        }
        Contraption contraption = this.movedContraption.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        if (this.getTargetOffset() != (int)this.offset) {
            return;
        }
        double y = this.movedContraption.m_20186_();
        int targetLevel = Mth.m_14107_((double)(0.5 + y));
        this.triggerContact(ec, targetLevel);
    }

    private void triggerContact(ElevatorContraption ec, int targetLevel) {
        ElevatorColumn.ColumnCoords coords = ec.getGlobalColumn();
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)this.f_58857_, coords);
        if (column == null) {
            return;
        }
        BlockPos contactPos = column.contactAt(targetLevel + ec.contactYOffset);
        if (!this.f_58857_.m_46749_(contactPos)) {
            return;
        }
        BlockState contactState = this.f_58857_.m_8055_(contactPos);
        if (!AllBlocks.ELEVATOR_CONTACT.has(contactState)) {
            return;
        }
        if (((Boolean)contactState.m_61143_((Property)ElevatorContactBlock.POWERING)).booleanValue()) {
            return;
        }
        ElevatorContactBlock ecb = (ElevatorContactBlock)AllBlocks.ELEVATOR_CONTACT.get();
        ecb.withBlockEntityDo((BlockGetter)this.f_58857_, contactPos, be -> {
            be.activateBlock = true;
        });
        ecb.scheduleActivation((LevelAccessor)this.f_58857_, contactPos);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128405_("ClientTarget", this.clientOffsetTarget);
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.clientOffsetTarget = compound.m_128451_("ClientTarget");
        if (this.initialOffsetReceived) {
            return;
        }
        this.offset = compound.m_128457_("Offset");
        this.initialOffsetReceived = true;
        this.resetContraptionToOffset();
    }

    @Override
    public float getMovementSpeed() {
        int currentTarget = this.getTargetOffset();
        if (!this.f_58857_.m_5776_() && currentTarget != this.clientOffsetTarget) {
            this.clientOffsetTarget = currentTarget;
            this.sendData();
        }
        float diff = (float)currentTarget - this.offset;
        float movementSpeed = Mth.m_14036_((float)ElevatorPulleyBlockEntity.convertToLinear(this.getSpeed() * 2.0f), (float)-1.99f, (float)1.99f);
        float rpmLimit = Math.abs(movementSpeed);
        float configacc = Mth.m_14179_((float)Math.abs(movementSpeed), (float)0.0075f, (float)0.0175f);
        float decelleration = (float)Math.sqrt(2.0f * Math.abs(diff) * configacc);
        float speed = diff;
        speed = Mth.m_14036_((float)speed, (float)(-rpmLimit), (float)rpmLimit);
        speed = Mth.m_14036_((float)speed, (float)(this.prevSpeed - configacc), (float)(this.prevSpeed + configacc));
        speed = Mth.m_14036_((float)speed, (float)(-decelleration), (float)decelleration);
        boolean bl = this.arrived = Math.abs(diff) < 0.5f;
        if (speed > 9.765625E-4f && !this.f_58857_.m_5776_()) {
            this.m_6596_();
        }
        this.prevSpeed = speed;
        return this.prevSpeed;
    }

    @Override
    protected boolean shouldCreateRopes() {
        return false;
    }

    @Override
    public void disassemble() {
        ElevatorContraption ec;
        ElevatorColumn column;
        Contraption contraption;
        if (this.movedContraption != null && (contraption = this.movedContraption.getContraption()) instanceof ElevatorContraption && (column = ElevatorColumn.get((LevelAccessor)this.f_58857_, (ec = (ElevatorContraption)contraption).getGlobalColumn())) != null) {
            column.setActive(false);
        }
        super.disassemble();
        this.offset = -1.0f;
        this.sendData();
    }

    public void clicked() {
        BlockEntity blockEntity;
        if (this.isPassive() && (blockEntity = this.f_58857_.m_7702_(this.mirrorParent)) instanceof ElevatorPulleyBlockEntity) {
            ElevatorPulleyBlockEntity parent = (ElevatorPulleyBlockEntity)blockEntity;
            parent.clicked();
            return;
        }
        if (this.running) {
            this.disassemble();
        } else {
            this.assembleNextTick = true;
        }
    }

    @Override
    protected boolean moveAndCollideContraption() {
        if (this.arrived) {
            return false;
        }
        super.moveAndCollideContraption();
        return false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    protected void assemble() throws AssemblyException {
        BlockPos ropePos;
        BlockState ropeState;
        int i;
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof ElevatorPulleyBlock)) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        int maxLength = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && ((ropeState = this.f_58857_.m_8055_(ropePos = this.f_58858_.m_6625_(i))).m_60812_((BlockGetter)this.f_58857_, ropePos).m_83281_() || ropeState.m_60767_().m_76336_()); ++i) {
        }
        this.offset = i - 1;
        this.forceMove = true;
        if (!this.f_58857_.f_46443_ && this.mirrorParent == null) {
            this.needsContraption = false;
            BlockPos anchor = this.f_58858_.m_6625_(Mth.m_14143_((float)(this.offset + 1.0f)));
            this.offset = Mth.m_14143_((float)this.offset);
            ElevatorContraption contraption = new ElevatorContraption((int)this.offset);
            float offsetOnSucess = this.offset;
            this.offset = 0.0f;
            boolean canAssembleStructure = contraption.assemble(this.f_58857_, anchor);
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            if (!contraption.getBlocks().isEmpty()) {
                this.offset = offsetOnSucess;
                contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
                this.movedContraption = ControlledContraptionEntity.create(this.f_58857_, this, contraption);
                this.movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
                contraption.maxContactY = this.f_58858_.m_123342_() + contraption.contactYOffset - 1;
                contraption.minContactY = contraption.maxContactY - maxLength;
                this.f_58857_.m_7967_((Entity)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
                for (BlockPos pos : contraption.createColliders(this.f_58857_, Direction.UP)) {
                    BlockEntity blockEntity;
                    if (pos.m_123342_() != 0 || !((blockEntity = this.f_58857_.m_7702_(new BlockPos((pos = pos.m_141952_((Vec3i)anchor)).m_123341_(), this.f_58858_.m_123342_(), pos.m_123343_()))) instanceof ElevatorPulleyBlockEntity)) continue;
                    ElevatorPulleyBlockEntity pbe = (ElevatorPulleyBlockEntity)blockEntity;
                    pbe.startMirroringOther(this.f_58858_);
                }
                ElevatorColumn column = ElevatorColumn.getOrCreate((LevelAccessor)this.f_58857_, contraption.getGlobalColumn());
                int target = (int)((float)(this.f_58858_.m_123342_() + contraption.contactYOffset - 1) - this.offset);
                column.target(target);
                column.gatherAll();
                column.setActive(true);
                column.markDirty();
                contraption.broadcastFloorData(this.f_58857_, column.contactAt(target));
                this.clientOffsetTarget = column.getTargetedYLevel();
                this.arrived = true;
            }
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        this.m_6596_();
    }

    @Override
    protected IControlContraption.MovementMode getMovementMode() {
        return IControlContraption.MovementMode.MOVE_NEVER_PLACE;
    }
}

