/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.classloading;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Supplier;
import malte0811.ferritecore.ducks.FastMapStateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class FastImmutableMapDefiner {
    public static String GOOGLE_ACCESS_PREFIX = "/googleaccess/";
    public static String GOOGLE_ACCESS_SUFFIX = ".class_manual";
    private static final Supplier<Definer> DEFINE_CLASS = Suppliers.memoize(() -> {
        try {
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(ImmutableMap.class, MethodHandles.lookup());
            return (bytes, name) -> privateLookup.defineClass(bytes);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    });
    private static final Supplier<MethodHandle> MAKE_IMMUTABLE_FAST_MAP = Suppliers.memoize(() -> {
        try {
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreEntrySetAccess");
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreImmutableMapAccess");
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreImmutableCollectionAccess");
            Class<?> map = Class.forName("malte0811.ferritecore.fastmap.immutable.FastMapEntryImmutableMap");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findConstructor(map, MethodType.methodType(Void.TYPE, FastMapStateHolder.class));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    });

    public static ImmutableMap<Property<?>, Comparable<?>> makeMap(FastMapStateHolder<?> state) {
        try {
            return MAKE_IMMUTABLE_FAST_MAP.get().invoke(state);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
    }

    private static void defineInAppClassloader(String name) throws Exception {
        byte[] classBytes;
        InputStream byteInput = FastImmutableMapDefiner.class.getResourceAsStream(GOOGLE_ACCESS_PREFIX + name.replace('.', '/') + GOOGLE_ACCESS_SUFFIX);
        int bytesRead = byteInput.read(classBytes = new byte[byteInput.available()]);
        Preconditions.checkState((bytesRead == classBytes.length ? 1 : 0) != 0);
        Class<?> loaded = DEFINE_CLASS.get().define(classBytes, name);
        Preconditions.checkState((loaded.getClassLoader() == ImmutableMap.class.getClassLoader() ? 1 : 0) != 0);
    }

    private static interface Definer {
        public Class<?> define(byte[] var1, String var2) throws Exception;
    }
}

