/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.tasks;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.mixin.FishingBobberEntityAccessorMixin;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GoFishingTask
extends Behavior<Villager> {
    private static final int MAX_RUN_TIME = 800;
    private static final int TURN_TIME = 60;
    private long bobberCountdown;
    private boolean hasThrownBobber = false;
    @Nullable
    private BlockPos targetBlockPos;
    @Nullable
    private FishingHook bobber = null;

    public GoFishingTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT), 800);
    }

    protected boolean shouldRun(ServerLevel serverWorld, Villager villagerEntity) {
        if (villagerEntity.m_20069_()) {
            return false;
        }
        BlockPos villagerPos = villagerEntity.m_142538_();
        for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)villagerPos, (int)LibertyVillagersMod.CONFIG.villagersProfessionConfig.fishermanFishingWaterRange, (int)LibertyVillagersMod.CONFIG.villagersProfessionConfig.fishermanFishingWaterRange, (int)LibertyVillagersMod.CONFIG.villagersProfessionConfig.fishermanFishingWaterRange)) {
            Vec3 lowerRightEdge;
            Vec3 lowerLeftEdge;
            Vec3 bobberStartPosition;
            if (blockPos.m_123342_() > villagerPos.m_123342_() || blockPos.m_123314_((Vec3i)villagerPos, 1.0) || !serverWorld.m_8055_(blockPos).m_60819_().m_76170_() || !serverWorld.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50016_) || serverWorld.m_8055_(new BlockPos(bobberStartPosition = this.getBobberStartPosition(villagerEntity, blockPos))).m_60815_()) continue;
            Vec3 centerBlockPos = Vec3.m_82512_((Vec3i)blockPos);
            AABB box = EntityType.f_20533_.m_20680_().m_20393_(bobberStartPosition);
            Vec3 lowerEdge = new Vec3(0.0, -1.0 * box.m_82376_() / 2.0, 0.0);
            if (this.doesNotHitValidWater(bobberStartPosition, lowerEdge, centerBlockPos, villagerEntity, serverWorld) || ProjectileUtil.m_37304_((Level)serverWorld, (Entity)villagerEntity, (Vec3)bobberStartPosition, (Vec3)centerBlockPos, (AABB)box, Entity::m_6084_) != null || this.doesNotHitValidWater(bobberStartPosition, lowerLeftEdge = new Vec3(-1.0 * box.m_82362_() / 2.0, -1.0 * box.m_82376_() / 2.0, 0.0), centerBlockPos, villagerEntity, serverWorld) || this.doesNotHitValidWater(bobberStartPosition, lowerRightEdge = new Vec3(1.0 * box.m_82362_() / 2.0, -1.0 * box.m_82376_() / 2.0, 0.0), centerBlockPos, villagerEntity, serverWorld)) continue;
            this.targetBlockPos = blockPos;
            return true;
        }
        return false;
    }

    protected void run(ServerLevel serverWorld, Villager villagerEntity, long time) {
        villagerEntity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
        villagerEntity.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetBlockPos.m_7494_()));
        villagerEntity.m_21563_().m_24964_(Vec3.m_82528_((Vec3i)this.targetBlockPos.m_7494_()));
        this.bobberCountdown = 60L + time;
    }

    protected boolean shouldKeepRunning(ServerLevel world, Villager entity, long time) {
        if (!entity.m_21205_().m_150930_(Items.f_42523_)) {
            return false;
        }
        if (!this.hasThrownBobber) {
            return true;
        }
        if (this.bobber == null || this.bobber.m_146910_() || this.bobber.m_20096_() && !this.bobber.m_146900_().m_60713_(Blocks.f_49990_)) {
            return false;
        }
        if (this.bobber.m_20088_() == null) {
            return true;
        }
        boolean caughtFish = (Boolean)this.bobber.m_20088_().m_135370_(FishingBobberEntityAccessorMixin.getCaughtFish());
        return !caughtFish;
    }

    protected void keepRunning(ServerLevel serverWorld, Villager villagerEntity, long time) {
        if (!this.hasThrownBobber && time > this.bobberCountdown) {
            this.throwBobber(villagerEntity, serverWorld);
        }
    }

    protected void finishRunning(ServerLevel serverWorld, Villager villagerEntity, long l) {
        villagerEntity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        villagerEntity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        if (this.bobber != null) {
            this.bobber.m_37156_(ItemStack.f_41583_);
            this.bobber = null;
        }
        villagerEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.hasThrownBobber = false;
        this.bobberCountdown = 0L;
    }

    Vec3 getBobberStartPosition(Villager thrower, BlockPos targetBlockPos) {
        Vec3 targetPosition = Vec3.m_82512_((Vec3i)targetBlockPos);
        double d = targetPosition.f_82479_ - thrower.m_20185_();
        double e = targetPosition.f_82480_ - thrower.m_20188_();
        double f = targetPosition.f_82481_ - thrower.m_20189_();
        double x = thrower.m_20185_() + d * 0.3;
        double y = thrower.m_20188_();
        double z = thrower.m_20189_() + f * 0.3;
        return new Vec3(x, y, z);
    }

    void throwBobber(Villager thrower, ServerLevel serverWorld) {
        this.bobber = new FishingHook(EntityType.f_20533_, (Level)serverWorld);
        this.bobber.m_5602_((Entity)thrower);
        Vec3 bobberStartPosition = this.getBobberStartPosition(thrower, this.targetBlockPos);
        this.bobber.m_7678_(bobberStartPosition.f_82479_, bobberStartPosition.f_82480_, bobberStartPosition.f_82481_, thrower.m_146908_(), thrower.m_146909_());
        Vec3 targetPosition = Vec3.m_82512_((Vec3i)this.targetBlockPos);
        double d = targetPosition.f_82479_ - bobberStartPosition.f_82479_;
        double e = targetPosition.f_82480_ - bobberStartPosition.f_82480_;
        double f = targetPosition.f_82481_ - bobberStartPosition.f_82481_;
        double g = 0.1;
        Vec3 vec3d = new Vec3(d * g, e * g, f * g);
        this.bobber.m_20256_(vec3d);
        this.bobber.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875));
        this.bobber.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)vec3d.m_165924_()) * 57.2957763671875));
        this.bobber.f_19859_ = this.bobber.m_146908_();
        this.bobber.f_19860_ = this.bobber.m_146909_();
        serverWorld.m_7967_((Entity)this.bobber);
        serverWorld.m_6263_(null, thrower.m_20185_(), thrower.m_20186_(), thrower.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (serverWorld.m_5822_().nextFloat() * 0.4f + 0.8f));
        this.hasThrownBobber = true;
    }

    boolean doesNotHitValidWater(Vec3 bobberStartPosition, Vec3 bobberEdge, Vec3 centerBlockPos, Villager villagerEntity, ServerLevel serverWorld) {
        BlockHitResult hitResult = serverWorld.m_45547_(new ClipContext(bobberStartPosition.m_82549_(bobberEdge), centerBlockPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)villagerEntity));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockState blockState = serverWorld.m_8055_(hitResult.m_82425_());
            return !blockState.m_60713_(Blocks.f_49990_) || !blockState.m_60819_().m_76170_();
        }
        return true;
    }
}

