/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.overlay;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.cmds.VillagerInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class LibertyVillagersOverlay {
    static int WHITE = 0xFFFFFF;
    static int TEXT_PADDING = 2;
    static int BACKGROUND_PADDING = 2;
    static int BACKGROUND_COLOR = 0x55200000;

    public static void HudRenderCallback(PoseStack matrices, float tickDelta) {
        if (!LibertyVillagersMod.CONFIG.debugConfig.enableVillagerInfoOverlay) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        HitResult hit = client.f_91077_;
        List<Component> lines = null;
        ServerLevel world = null;
        if (client.m_91091_()) {
            world = client.m_91092_().m_129880_(client.f_91073_.m_46472_());
        }
        switch (hit.m_6662_()) {
            case MISS: {
                break;
            }
            case BLOCK: {
                BlockHitResult blockHit = (BlockHitResult)hit;
                BlockPos blockPos = blockHit.m_82425_();
                BlockState blockState = client.f_91073_.m_8055_(blockPos);
                lines = VillagerInfo.getBlockInfo(world, blockPos, blockState);
                break;
            }
            case ENTITY: {
                EntityHitResult entityHit = (EntityHitResult)hit;
                Object entity = entityHit.m_82443_();
                if (client.m_91091_()) {
                    entity = world.m_8791_(entity.m_142081_());
                }
                lines = VillagerInfo.getEntityInfo(world, (Entity)entity);
            }
        }
        if (lines != null) {
            int windowScaledWidth = client.m_91268_().m_85445_();
            Font renderer = client.f_91062_;
            MultiLineLabel multilineText = MultiLineLabel.m_169036_((Font)renderer, lines);
            int maxWidth = 0;
            for (Component line : lines) {
                maxWidth = Math.max(renderer.m_92852_((FormattedText)line), maxWidth);
            }
            int multilineWidth = maxWidth + TEXT_PADDING;
            int x = windowScaledWidth - multilineWidth;
            int n = x + multilineWidth / 2 - BACKGROUND_PADDING / 2;
            Objects.requireNonNull(renderer);
            multilineText.m_207298_(matrices, n, TEXT_PADDING, 9, BACKGROUND_PADDING, BACKGROUND_COLOR);
            Objects.requireNonNull(renderer);
            multilineText.m_6508_(matrices, x, TEXT_PADDING, 9, WHITE);
        }
    }
}

