/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MoveTowardsTargetGoal.class})
public abstract class WanderNearTargetGoalMixin {
    @Shadow
    private PathfinderMob f_25638_;

    void checkForValidTarget(CallbackInfoReturnable<Boolean> cir) {
        if (this.f_25638_.m_6095_() != EntityType.f_20460_) {
            return;
        }
        if (this.f_25638_.m_5448_() == null) {
            return;
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemStayNearBell) {
            BlockPos nearestBellPos;
            Vec3 targetPos = this.f_25638_.m_5448_().m_20182_();
            ServerLevel serverWorld = (ServerLevel)this.f_25638_.f_19853_;
            PoiManager pointOfInterestStorage = serverWorld.m_8904_();
            Optional nearestBell = pointOfInterestStorage.m_27192_(PoiType.f_27347_.m_27392_(), this.f_25638_.m_142538_(), 2 * LibertyVillagersMod.CONFIG.golemsConfig.golemMaxBellRange, PoiManager.Occupancy.ANY);
            if (nearestBell.isPresent() && !(nearestBellPos = (BlockPos)nearestBell.get()).m_203195_((Position)targetPos, (double)LibertyVillagersMod.CONFIG.golemsConfig.golemMaxBellRange)) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemsAvoidWater && this.f_25638_.m_5448_().m_20069_()) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"canStart"}, at={@At(value="HEAD")}, cancellable=true)
    private void canStartIfNotTooFarFromBell(CallbackInfoReturnable<Boolean> cir) {
        this.checkForValidTarget(cir);
    }

    @Inject(method={"shouldContinue"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldContinueIfNotTooFarFromBell(CallbackInfoReturnable<Boolean> cir) {
        this.checkForValidTarget(cir);
    }
}

