/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.mixin.TaskAccessorMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MoveToTargetSink.class})
public abstract class WanderAroundTaskMixin {
    private static final int MAX_RUN_TIME = 1200;
    private static final long STUCK_TIME = 60L;
    @Shadow
    @Nullable
    private Path f_23568_;
    private WalkTarget walkTarget = null;
    @Nullable
    private BlockPos previousEntityPos = null;
    private long previousEntityPosTime;
    private int fuzzyTries;

    @Shadow
    abstract boolean m_23589_(Mob var1, WalkTarget var2);

    @Inject(method={"<init>()V"}, at={@At(value="TAIL")})
    public void replaceFarmerVillagerTaskRunTime(CallbackInfo ci) {
        ((TaskAccessorMixin)((Object)this)).setMaxRunTime(1200);
        ((TaskAccessorMixin)((Object)this)).setMinRunTime(1200);
    }

    @Inject(method={"hasFinishedPath(Lnet/minecraft/entity/mob/MobEntity;Lnet/minecraft/entity/ai/brain/WalkTarget;J)Z"}, at={@At(value="HEAD")})
    private void storeWalkTargetFromHasFinishedPath(Mob entity, WalkTarget walkTarget, long time, CallbackInfoReturnable<Boolean> cir) {
        this.walkTarget = walkTarget;
    }

    private void checkToSeeIfVillagerHasMoved(ServerLevel serverWorld, Mob entity, long time) {
        BlockPos entityPos = new BlockPos((double)entity.m_146903_(), WalkNodeEvaluator.m_77611_((BlockGetter)serverWorld, (BlockPos)entity.m_142538_()), (double)entity.m_146907_());
        if (this.previousEntityPos == null || !this.previousEntityPos.m_123314_((Vec3i)entityPos, 1.0)) {
            this.previousEntityPos = entityPos;
            this.previousEntityPosTime = time;
            this.fuzzyTries = 0;
        }
    }

    @Inject(method={"keepRunning"}, at={@At(value="HEAD")})
    private void keepRunningCheckToSeeIfVillagerHasMoved(ServerLevel serverWorld, Mob entity, long time, CallbackInfo ci) {
        this.checkToSeeIfVillagerHasMoved(serverWorld, entity, time);
    }

    @Inject(method={"shouldRun"}, at={@At(value="HEAD")})
    protected void shouldRun(ServerLevel serverWorld, Mob entity, CallbackInfoReturnable<Boolean> cir) {
        long time = serverWorld.m_46467_();
        this.checkToSeeIfVillagerHasMoved(serverWorld, entity, time);
    }

    private boolean lastDitchAttemptToFindPath(Mob entity, long time) {
        if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagerWanderingFix && entity.m_6095_() == EntityType.f_20492_ && this.previousEntityPosTime > 0L && time - this.previousEntityPosTime > 60L) {
            if (this.fuzzyTries > 3) {
                Vec3 desiredPos;
                boolean shouldRun = false;
                if (this.f_23568_ != null) {
                    BlockPos blockPos = this.f_23568_.m_77400_();
                    desiredPos = new Vec3((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + 0.5f));
                    shouldRun = true;
                } else {
                    BlockPos blockPos = this.walkTarget.m_26420_().m_6675_();
                    desiredPos = new Vec3((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() + 0.5f));
                }
                entity.m_20984_(desiredPos.f_82479_, desiredPos.f_82480_, desiredPos.f_82481_, true);
                this.previousEntityPosTime = 0L;
                return shouldRun;
            }
            BlockPos blockPos = this.walkTarget.m_26420_().m_6675_();
            Vec3 vec3d = DefaultRandomPos.m_148412_((PathfinderMob)((PathfinderMob)entity), (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)blockPos), (double)1.5707963705062866);
            if (vec3d != null) {
                this.f_23568_ = entity.m_21573_().m_26524_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 0);
            }
            ++this.fuzzyTries;
            this.previousEntityPosTime = time;
            return this.f_23568_ != null;
        }
        return false;
    }

    @Inject(method={"keepRunning"}, at={@At(value="TAIL")})
    private void keepRunninglastDitchAttemptToFindPath(ServerLevel serverWorld, Mob entity, long time, CallbackInfo ci) {
        if (this.walkTarget == null) {
            if (entity.m_6274_().m_21952_(MemoryModuleType.f_26370_).isEmpty()) {
                return;
            }
            this.walkTarget = (WalkTarget)entity.m_6274_().m_21952_(MemoryModuleType.f_26370_).get();
        }
        this.lastDitchAttemptToFindPath(entity, time);
    }

    @Inject(method={"hasFinishedPath(Lnet/minecraft/entity/mob/MobEntity;Lnet/minecraft/entity/ai/brain/WalkTarget;J)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void hasFinishedPathLastDitchAttemptToFindPath(Mob entity, WalkTarget walkTarget, long time, CallbackInfoReturnable<Boolean> cir) {
        if (this.lastDitchAttemptToFindPath(entity, time)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @ModifyArg(method={"hasFinishedPath(Lnet/minecraft/entity/mob/MobEntity;Lnet/minecraft/entity/ai/brain/WalkTarget;J)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/pathing/EntityNavigation;findPathTo(Lnet/minecraft/util/math/BlockPos;I)Lnet/minecraft/entity/ai/pathing/Path;"), index=1)
    int replaceDistanceInFindPathToInHasFinishedPath(int distance) {
        if (this.walkTarget.m_26420_() instanceof BlockPosTracker) {
            return Math.max(1, distance);
        }
        return distance;
    }
}

