/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WaterAvoidingRandomStrollGoal.class})
public abstract class WanderAroundFarGoalMixin
extends RandomStrollGoal {
    public WanderAroundFarGoalMixin() {
        super(null, 0.0, 240, false);
    }

    @Inject(method={"getWanderTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWanderTargetDoesNotExceedRange(CallbackInfoReturnable<Vec3> cir) {
        BlockPos nearestBellPos;
        if (!LibertyVillagersMod.CONFIG.catsConfig.catsStayNearBell) {
            return;
        }
        if (this.f_25725_.m_6095_() != EntityType.f_20553_) {
            return;
        }
        Vec3 dest = (Vec3)cir.getReturnValue();
        if (dest == null) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)this.f_25725_.f_19853_;
        PoiManager pointOfInterestStorage = serverWorld.m_8904_();
        Optional nearestBell = pointOfInterestStorage.m_27192_(PoiType.f_27347_.m_27392_(), this.f_25725_.m_142538_(), 2 * LibertyVillagersMod.CONFIG.catsConfig.catsMaxBellRange, PoiManager.Occupancy.ANY);
        if (nearestBell.isPresent() && !(nearestBellPos = (BlockPos)nearestBell.get()).m_203195_((Position)dest, (double)LibertyVillagersMod.CONFIG.catsConfig.catsMaxBellRange)) {
            dest = LandRandomPos.m_148492_((PathfinderMob)this.f_25725_, (int)10, (int)7, (Vec3)Vec3.m_82528_((Vec3i)nearestBellPos));
            cir.setReturnValue((Object)dest);
            cir.cancel();
        }
    }
}

