/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.SetClosestHomeAsWalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SetClosestHomeAsWalkTarget.class})
public abstract class WalkHomeTaskMixin
extends Behavior<LivingEntity> {
    private ServerLevel world;
    private LivingEntity entity;

    public WalkHomeTaskMixin() {
        super((Map)ImmutableMap.of());
    }

    @Redirect(method={"shouldRun(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;getSquaredDistance(Lnet/minecraft/util/math/Vec3i;)D"))
    private double replaceSquaredDistanceWithManhattan(BlockPos origin, Vec3i dest) {
        return origin.m_123333_(dest);
    }

    @ModifyConstant(method={"shouldRun(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)Z"}, constant={@Constant(doubleValue=4.0)})
    private double replaceSquaredDistanceWithManhattanConstant(double constant) {
        return 2.0;
    }

    @ModifyArg(method={"shouldRun(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getNearestPosition(Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/Optional;"), index=2)
    protected int modifyShouldRunGetNearestPositionArgs(int findPOIRange) {
        return LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange;
    }

    @Inject(method={"run(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;J)V"}, at={@At(value="HEAD")})
    protected void runHead(ServerLevel world, LivingEntity entity, long time, CallbackInfo ci) {
        this.world = world;
        this.entity = entity;
    }

    @Redirect(method={"run(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getPositions(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/stream/Stream;"))
    public Stream<BlockPos> modifyGetTypesAndPositions(PoiManager pointOfInterestStorage, Predicate<PoiType> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        Predicate<BlockPos> newBlockPosPredicate = blockPos -> {
            if (this.isBedOccupiedByOthers(this.world, (BlockPos)blockPos, this.entity)) {
                return false;
            }
            return posPredicate.test((BlockPos)blockPos);
        };
        Set set = pointOfInterestStorage.m_27171_(typePredicate, newBlockPosPredicate, pos, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange, PoiManager.Occupancy.HAS_SPACE).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            return set.stream();
        }
        return pointOfInterestStorage.m_27171_(typePredicate, posPredicate, pos, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange, occupationStatus);
    }

    private boolean isBedOccupiedByOthers(ServerLevel world, BlockPos pos, LivingEntity entity) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13038_) && (Boolean)blockState.m_61143_((Property)BedBlock.f_49441_) != false && !entity.m_5803_();
    }
}

