/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.google.common.collect.ImmutableSet;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerProfession.class})
public abstract class VillagerProfessionMixin {
    @Shadow
    private String f_35600_;

    @Inject(method={"getSecondaryJobSites"}, at={@At(value="HEAD")}, cancellable=true)
    void replaceSecondaryJobSites(CallbackInfoReturnable<ImmutableSet<Block>> cir) {
        switch (this.f_35600_) {
            case "librarian": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.librariansLookAtBooks) break;
                cir.setReturnValue((Object)ImmutableSet.of((Object)Blocks.f_50078_));
                cir.cancel();
                break;
            }
            case "fisherman": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.fishermanFish) break;
                cir.setReturnValue((Object)ImmutableSet.of((Object)Blocks.f_49990_));
                cir.cancel();
            }
        }
    }

    @Inject(method={"getGatherableItems"}, at={@At(value="RETURN")}, cancellable=true)
    void replaceGatherableItems(CallbackInfoReturnable<ImmutableSet<Item>> cir) {
        ImmutableSet originalSet = (ImmutableSet)cir.getReturnValue();
        ImmutableSet.Builder setBuilder = ImmutableSet.builder().addAll((Iterable)originalSet);
        switch (this.f_35600_) {
            case "butcher": {
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedChickens) {
                    setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42577_, (Object)Items.f_42404_, (Object)Items.f_42733_));
                }
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedCows && !LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedSheep) break;
                setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42405_));
                break;
            }
            case "farmer": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins) break;
                setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42577_, (Object)Items.f_42046_));
                break;
            }
            case "fisherman": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.fishermanFish) break;
                setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42526_, (Object)Items.f_42527_));
                break;
            }
            case "fletcher": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.fletchersFeedChickens) break;
                setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42577_, (Object)Items.f_42404_, (Object)Items.f_42733_));
                break;
            }
            case "leatherworker": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.leatherworkersFeedCows) break;
                setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42405_));
                break;
            }
            case "shepherd": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.shepherdsFeedSheep) break;
                setBuilder.addAll((Iterable)ImmutableSet.of((Object)Items.f_42405_));
            }
        }
        cir.setReturnValue((Object)setBuilder.build());
        cir.cancel();
    }
}

