/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AcquirePoi.class})
public abstract class FindPointOfInterestTaskMixin
extends Behavior<PathfinderMob> {
    private static final long TIME_NIGHT = 13000L;
    private ServerLevel world;
    private PathfinderMob entity;
    @Shadow
    private MemoryModuleType<GlobalPos> f_22317_;

    public FindPointOfInterestTaskMixin() {
        super((Map)ImmutableMap.of());
    }

    @Inject(method={"shouldRun(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/mob/PathAwareEntity;)Z"}, at={@At(value="Head")}, cancellable=true)
    protected void dontFindWorkstationsAtNight(ServerLevel serverWorld, PathfinderMob pathAwareEntity, CallbackInfoReturnable<Boolean> cir) {
        long timeOfDay = serverWorld.m_46468_() % 24000L;
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.villagersDontLookForWorkstationsAtNight && pathAwareEntity.m_6095_() == EntityType.f_20492_ && (this.f_22317_ == MemoryModuleType.f_26361_ || this.f_22317_ == MemoryModuleType.f_26362_) && timeOfDay > 13000L) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"run(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/mob/PathAwareEntity;J)V"}, at={@At(value="Head")})
    private void getLivingEntityForRun(ServerLevel world, PathfinderMob entity, long l, CallbackInfo ci) {
        this.entity = entity;
        this.world = world;
    }

    @Redirect(method={"run(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/mob/PathAwareEntity;J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getSortedPositions(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/stream/Stream;"))
    public Stream<BlockPos> modifyGetSortedPositions(PoiManager pointOfInterestStorage, Predicate<PoiType> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        Predicate<BlockPos> newBlockPosPredicate = blockPos -> {
            if (this.isBedOccupiedByOthers(this.world, (BlockPos)blockPos, (LivingEntity)this.entity)) {
                return false;
            }
            return posPredicate.test((BlockPos)blockPos);
        };
        return pointOfInterestStorage.m_27171_(typePredicate, newBlockPosPredicate, pos, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange, PoiManager.Occupancy.HAS_SPACE);
    }

    private boolean isBedOccupiedByOthers(ServerLevel world, BlockPos pos, LivingEntity entity) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13038_) && (Boolean)blockState.m_61143_((Property)BedBlock.f_49441_) != false && !entity.m_5803_();
    }
}

