/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.mixin.TaskAccessorMixin;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HarvestFarmland.class})
public abstract class FarmerVillagerTaskMixin
extends Behavior<Villager> {
    private static final int MAX_RUN_TIME = 1200;
    @Shadow
    @Nullable
    private BlockPos f_23159_;
    @Shadow
    private long f_23160_;
    @Shadow
    private int f_23161_;
    @Shadow
    private List<BlockPos> f_23162_;

    public FarmerVillagerTaskMixin() {
        super((Map)ImmutableMap.of());
    }

    @Shadow
    @Nullable
    abstract BlockPos m_23164_(ServerLevel var1);

    @Inject(method={"<init>()V"}, at={@At(value="TAIL")})
    public void replaceFarmerVillagerTaskRunTime(CallbackInfo ci) {
        ((TaskAccessorMixin)((Object)this)).setMaxRunTime(1200);
        ((TaskAccessorMixin)((Object)this)).setMinRunTime(1200);
    }

    @Inject(method={"shouldRun"}, at={@At(value="HEAD")}, cancellable=true)
    protected void replaceShouldRun(ServerLevel serverWorld, Villager villagerEntity, CallbackInfoReturnable<Boolean> cir) {
        if (!serverWorld.m_46469_().m_46207_(GameRules.f_46132_)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        } else if (villagerEntity.m_7141_().m_35571_() != VillagerProfession.f_35590_) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        } else {
            BlockPos.MutableBlockPos mutable = villagerEntity.m_142538_().m_122032_();
            this.f_23162_.clear();
            for (int i = -1 * LibertyVillagersMod.CONFIG.villagersProfessionConfig.findCropRangeHorizontal; i <= LibertyVillagersMod.CONFIG.villagersProfessionConfig.findCropRangeHorizontal; ++i) {
                for (int j = -1 * LibertyVillagersMod.CONFIG.villagersProfessionConfig.findCropRangeVertical; j <= LibertyVillagersMod.CONFIG.villagersProfessionConfig.findCropRangeVertical; ++j) {
                    for (int k = -LibertyVillagersMod.CONFIG.villagersProfessionConfig.findCropRangeHorizontal; k <= LibertyVillagersMod.CONFIG.villagersProfessionConfig.findCropRangeHorizontal; ++k) {
                        mutable.m_122169_(villagerEntity.m_20185_() + (double)i, villagerEntity.m_20186_() + (double)j, villagerEntity.m_20189_() + (double)k);
                        if (!this.replaceIsSuitableTarget((BlockPos)mutable, serverWorld, villagerEntity)) continue;
                        this.f_23162_.add(new BlockPos((Vec3i)mutable));
                    }
                }
            }
            this.f_23159_ = this.m_23164_(serverWorld);
            cir.setReturnValue((Object)(this.f_23159_ != null ? 1 : 0));
            cir.cancel();
        }
    }

    @Inject(method={"keepRunning"}, at={@At(value="HEAD")}, cancellable=true)
    protected void keepRunning(ServerLevel serverWorld, Villager villagerEntity, long l, CallbackInfo cir) {
        if (!(LibertyVillagersMod.CONFIG.villagersProfessionConfig.preferPlantSameCrop || LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins || LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestMelons)) {
            return;
        }
        if (villagerEntity.m_6274_().m_21874_(MemoryModuleType.f_26370_)) {
            cir.cancel();
            return;
        }
        Item preferredSeeds = null;
        BlockPos currentTarget = this.f_23159_;
        int distance = 2;
        BlockState blockState = serverWorld.m_8055_(currentTarget);
        Block block = blockState.m_60734_();
        Block block2 = serverWorld.m_8055_(currentTarget.m_7495_()).m_60734_();
        if (currentTarget.m_203195_((Position)villagerEntity.m_20182_(), (double)distance)) {
            boolean foundBlockCrop = false;
            if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.preferPlantSameCrop && block instanceof CropBlock && ((CropBlock)block).m_52307_(blockState)) {
                foundBlockCrop = true;
                preferredSeeds = this.getPreferredSeedsForCropBlock(block);
            }
            if (block instanceof StemGrownBlock) {
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestMelons && block instanceof MelonBlock) {
                    foundBlockCrop = true;
                }
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins && block instanceof PumpkinBlock) {
                    foundBlockCrop = true;
                }
            }
            if (foundBlockCrop) {
                serverWorld.m_46953_(currentTarget, true, (Entity)villagerEntity);
                blockState = serverWorld.m_8055_(currentTarget);
            }
            if (blockState.m_60795_() && block2 instanceof FarmBlock && villagerEntity.m_35516_()) {
                ItemStack itemStack;
                SimpleContainer simpleInventory = villagerEntity.m_141944_();
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.preferPlantSameCrop && preferredSeeds == null) {
                    BlockPos blockPos;
                    BlockState possibleCropState;
                    Block possibleCrop;
                    Iterator iterator = BlockPos.m_121940_((BlockPos)currentTarget.m_142082_(-4, 0, -4), (BlockPos)currentTarget.m_142082_(4, 1, 4)).iterator();
                    while (iterator.hasNext() && (!((possibleCrop = (possibleCropState = serverWorld.m_8055_(blockPos = (BlockPos)iterator.next())).m_60734_()) instanceof CropBlock) && !(possibleCrop instanceof StemGrownBlock) && !(possibleCrop instanceof StemBlock) || (preferredSeeds = this.getPreferredSeedsForCropBlock(possibleCrop)) == null)) {
                    }
                }
                boolean plantedPreferredSeeds = false;
                if (preferredSeeds != null) {
                    for (int i = 0; !(i >= simpleInventory.m_6643_() || !(itemStack = simpleInventory.m_8020_(i)).m_41619_() && itemStack.m_150930_(preferredSeeds) && (plantedPreferredSeeds = this.plantSeed(itemStack, i, serverWorld, villagerEntity))); ++i) {
                    }
                }
                if (!(plantedPreferredSeeds || LibertyVillagersMod.CONFIG.villagersProfessionConfig.preferPlantSameCrop && preferredSeeds != null)) {
                    for (int i = 0; i < simpleInventory.m_6643_(); ++i) {
                        itemStack = simpleInventory.m_8020_(i);
                        if (!(LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins && itemStack.m_150930_(Items.f_42046_) && simpleInventory.m_18949_((Set)ImmutableSet.of((Object)Items.f_42577_)) || LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins && itemStack.m_150930_(Items.f_42575_) && simpleInventory.m_18949_((Set)ImmutableSet.of((Object)Items.f_42578_)) || itemStack.m_41619_() || !this.plantSeed(itemStack, i, serverWorld, villagerEntity))) break;
                    }
                }
            }
            this.f_23162_.remove(currentTarget);
            this.f_23159_ = null;
        }
        if (this.f_23159_ == null) {
            this.f_23159_ = this.m_23164_(serverWorld);
        }
        if (this.f_23159_ != null) {
            this.f_23160_ = l + 20L;
            int completionRange = 0;
            if (serverWorld.m_8055_(this.f_23159_).m_60734_() instanceof StemGrownBlock) {
                completionRange = 2;
            }
            villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.f_23159_), 0.5f, completionRange));
            villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.f_23159_));
        }
        ++this.f_23161_;
        cir.cancel();
    }

    private Item getPreferredSeedsForCropBlock(Block block) {
        if (block instanceof StemBlock) {
            block = ((StemBlock)block).m_57056_();
        }
        if (block instanceof BeetrootBlock) {
            return Items.f_42733_;
        }
        if (block instanceof PotatoBlock) {
            return Items.f_42620_;
        }
        if (block instanceof CarrotBlock) {
            return Items.f_42619_;
        }
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestMelons && block instanceof MelonBlock) {
            return Items.f_42578_;
        }
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins && block instanceof PumpkinBlock) {
            return Items.f_42577_;
        }
        if (block instanceof CropBlock) {
            return Items.f_42404_;
        }
        return null;
    }

    private boolean plantSeed(ItemStack itemStack, int stackIndex, ServerLevel serverWorld, Villager villagerEntity) {
        BlockState blockState2;
        BlockPos currentTarget = this.f_23159_;
        if (itemStack.m_150930_(Items.f_42404_)) {
            blockState2 = Blocks.f_50092_.m_49966_();
        } else if (itemStack.m_150930_(Items.f_42620_)) {
            blockState2 = Blocks.f_50250_.m_49966_();
        } else if (itemStack.m_150930_(Items.f_42619_)) {
            blockState2 = Blocks.f_50249_.m_49966_();
        } else if (itemStack.m_150930_(Items.f_42733_)) {
            blockState2 = Blocks.f_50444_.m_49966_();
        } else if (itemStack.m_150930_(Items.f_42578_) || itemStack.m_150930_(Items.f_42575_)) {
            blockState2 = Blocks.f_50190_.m_49966_();
        } else if (itemStack.m_150930_(Items.f_42577_) || itemStack.m_150930_(Items.f_42046_)) {
            if (itemStack.m_150930_(Items.f_42046_)) {
                ItemStack pumpkinSeedItemStack = new ItemStack((ItemLike)Items.f_42577_, 3);
                villagerEntity.m_141944_().m_19173_(pumpkinSeedItemStack);
            }
            blockState2 = Blocks.f_50189_.m_49966_();
        } else {
            return false;
        }
        serverWorld.m_46597_(currentTarget, blockState2);
        serverWorld.m_6263_(null, (double)currentTarget.m_123341_(), (double)currentTarget.m_123342_(), (double)currentTarget.m_123343_(), SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
        itemStack.m_41774_(1);
        if (itemStack.m_41619_()) {
            villagerEntity.m_141944_().m_6836_(stackIndex, ItemStack.f_41583_);
        }
        return true;
    }

    protected boolean replaceIsSuitableTarget(BlockPos pos, ServerLevel world, Villager villagerEntity) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        Block block2 = world.m_8055_(pos.m_7495_()).m_60734_();
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestMelons && block instanceof MelonBlock) {
            return true;
        }
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins && block instanceof PumpkinBlock) {
            return true;
        }
        return block instanceof CropBlock && ((CropBlock)block).m_52307_(blockState) || blockState.m_60795_() && block2 instanceof FarmBlock && villagerEntity.m_35516_();
    }

    @Inject(method={"shouldKeepRunning"}, at={@At(value="HEAD")}, cancellable=true)
    protected void replaceShouldKeepRunning(ServerLevel serverWorld, Villager villagerEntity, long l, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_23159_ == null) {
            this.f_23159_ = this.m_23164_(serverWorld);
        }
        cir.setReturnValue((Object)(this.f_23159_ != null && this.f_23161_ < 1200 ? 1 : 0));
        cir.cancel();
    }
}

