/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.pathfinder.Path;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Brain.class})
public abstract class BrainMixin<E extends LivingEntity> {
    private LivingEntity entity;
    @Shadow
    private Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> f_21843_ = Maps.newHashMap();

    BrainMixin() {
    }

    @Inject(method={"tick(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="HEAD")})
    public void getEntityFromTick(ServerLevel world, E entity, CallbackInfo ci) {
        this.entity = entity;
    }

    @Inject(method={"setMemory(Lnet/minecraft/entity/ai/brain/MemoryModuleType;Ljava/util/Optional;)V"}, at={@At(value="Head")})
    <U> void setMemory(MemoryModuleType<U> type, Optional<? extends ExpirableValue<?>> memory, CallbackInfo ci) {
        String name;
        if (!LibertyVillagersMod.CONFIG.debugConfig.enableVillagerBrainDebug) {
            return;
        }
        Optional<? extends ExpirableValue<?>> optional = this.f_21843_.get(MemoryModuleType.f_26362_);
        if (optional == null) {
            return;
        }
        if (type != MemoryModuleType.f_26370_ && type != MemoryModuleType.f_26359_ && type != MemoryModuleType.f_26361_ && type != MemoryModuleType.f_26360_ && type != MemoryModuleType.f_26377_) {
            return;
        }
        Object className = "";
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < elements.length; ++i) {
            StackTraceElement s = elements[i];
            if (s.getFileName().contains("LookTargetUtil") || !s.getClassName().contains("ai.brain.task") && !s.getClassName().contains("ai.brain.sensor")) continue;
            String fileName = s.getFileName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            className = fileName + ":" + s.getMethodName() + ":" + s.getLineNumber();
            break;
        }
        String string = name = this.entity != null ? this.entity.m_7755_().toString() : "null";
        if (this.entity != null && this.entity.m_5446_() instanceof TranslatableComponent) {
            TranslatableComponent content = (TranslatableComponent)this.entity.m_7755_();
            String key = content.m_131328_();
            name = key.substring(key.lastIndexOf(46) + 1);
        }
        StringBuilder target = new StringBuilder();
        if (memory.isEmpty()) {
            target = new StringBuilder("null");
        } else if (type == MemoryModuleType.f_26370_) {
            WalkTarget walkTarget = (WalkTarget)memory.get().m_26319_();
            target = new StringBuilder(String.format("Walk Target set to position %s with range %d", walkTarget.m_26420_().m_6675_().m_123344_(), walkTarget.m_26422_()));
        } else if (type == MemoryModuleType.f_26359_ || type == MemoryModuleType.f_26361_ || type == MemoryModuleType.f_26360_) {
            GlobalPos globalPos = (GlobalPos)memory.get().m_26319_();
            target = new StringBuilder(String.format("Position set to %s", globalPos.m_122646_().m_123344_()));
        } else if (type == MemoryModuleType.f_26363_) {
            List globalPosList = (List)memory.get().m_26319_();
            for (GlobalPos globalPos : globalPosList) {
                target.append("{ ").append(globalPos.m_122646_().m_123344_()).append(" } ");
            }
        } else if (type == MemoryModuleType.f_26377_) {
            Path path = (Path)memory.get().m_26319_();
            for (int i = path.m_77399_(); i < path.m_77398_(); ++i) {
                target.append("{ ").append(path.m_77375_(i).m_77288_().m_123344_()).append(" } ");
            }
        }
        String pos = this.entity == null ? "" : this.entity.m_142538_().m_123344_();
        String memoryType = type.toString();
        memoryType = memoryType.substring(memoryType.lastIndexOf(58) + 1);
        System.out.printf("===== %s at %s memoryType %s set by %s to %s\n", name, pos, memoryType, className, target);
    }
}

