/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class VillagerSetPOI {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagerSetPOI").executes(context -> {
            VillagerSetPOI.processVillagerSetPOI((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagersetpoi").executes(context -> {
            VillagerSetPOI.processVillagerSetPOI((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"vsp").executes(context -> {
            VillagerSetPOI.processVillagerSetPOI((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
    }

    public static void processVillagerSetPOI(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        ServerPlayer player = source.m_81375_();
        ServerLevel serverWorld = source.m_81372_();
        float maxDistance = 50.0f;
        float tickDelta = 0.0f;
        HitResult hit = player.m_19907_((double)maxDistance, tickDelta, false);
        switch (hit.m_6662_()) {
            case MISS: {
                player.m_5661_((Component)new TranslatableComponent("text.LibertyVillagers.villagerSetPOI.miss"), false);
                break;
            }
            case BLOCK: {
                BlockHitResult blockHit = (BlockHitResult)hit;
                BlockPos blockPos = blockHit.m_82425_();
                BlockState blockState = serverWorld.m_8055_(blockPos);
                VillagerSetPOI.handleBlockHit(player, serverWorld, blockPos, blockState);
                break;
            }
            case ENTITY: {
                player.m_5661_((Component)new TranslatableComponent("text.LibertyVillagers.villagerSetPOI.entity"), false);
            }
        }
    }

    protected static void handleBlockHit(ServerPlayer player, ServerLevel serverWorld, BlockPos blockPos, BlockState blockState) {
        Block block = blockState.m_60734_();
        MutableComponent name = block.m_49954_();
        Optional optionalRegistryEntry = PoiType.m_27390_((BlockState)blockState);
        if (optionalRegistryEntry.isEmpty()) {
            player.m_5661_((Component)new TranslatableComponent("text.LibertyVillagers.villagerSetPOI.notPOIType", new Object[]{name}), false);
            return;
        }
        PoiType poiType = (PoiType)optionalRegistryEntry.get();
        String poiTypeName = poiType.m_148688_();
        PoiManager storage = serverWorld.m_8904_();
        if (!storage.m_27044_(poiType, blockPos)) {
            storage.m_27085_(blockPos, poiType);
            DebugPackets.m_133679_((ServerLevel)serverWorld, (BlockPos)blockPos);
            player.m_5661_((Component)new TranslatableComponent("text.LibertyVillagers.villagerSetPOI.enable", new Object[]{name, poiTypeName}), false);
        } else {
            storage.m_27079_(blockPos);
            DebugPackets.m_133716_((ServerLevel)serverWorld, (BlockPos)blockPos);
            player.m_5661_((Component)new TranslatableComponent("text.LibertyVillagers.villagerSetPOI.disable", new Object[]{name, poiTypeName}), false);
        }
    }
}

