/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.Loader;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import fuzs.configmenusforge.client.gui.data.EntryData;
import fuzs.configmenusforge.client.gui.data.IEntryData;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ConfigMenusForgeHelper {
    private static final Map<Class<?>, List<MethodHandle>> configSpecMethodHandles = Maps.newHashMap();
    private static final Map<Class<?>, Boolean> cachedConfigSpecClasses = Maps.newHashMap();
    private static final MethodType getValuesMethodType = MethodType.methodType(UnmodifiableConfig.class);
    private static final MethodType isLoadedMethodType = MethodType.methodType(Boolean.TYPE);
    private static final MethodType saveMethodType = MethodType.methodType(Void.TYPE);

    private static Object callMethod(UnmodifiableConfig spec, int methodIndex) {
        Class<?> specClass = spec.getClass();
        if (!cachedConfigSpecClasses.containsKey(specClass)) {
            ConfigMenusForgeHelper.cacheClass(specClass);
        }
        if (configSpecMethodHandles.containsKey(specClass)) {
            try {
                return configSpecMethodHandles.get(specClass).get(methodIndex).invoke(spec);
            }
            catch (Throwable e) {
                Loader.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public static UnmodifiableConfig getValues(UnmodifiableConfig spec) {
        return (UnmodifiableConfig)ConfigMenusForgeHelper.callMethod(spec, 0);
    }

    public static boolean isLoaded(UnmodifiableConfig spec) {
        return (Boolean)ConfigMenusForgeHelper.callMethod(spec, 1);
    }

    public static void save(UnmodifiableConfig spec) {
        ConfigMenusForgeHelper.callMethod(spec, 2);
    }

    public static Boolean cachedValidity(Class<?> specClass) {
        return cachedConfigSpecClasses.getOrDefault(specClass, null);
    }

    public static void cacheClass(Class<?> specClass) {
        MethodHandle getValuesMethod = null;
        MethodHandle isLoadedMethod = null;
        MethodHandle saveMethod = null;
        try {
            getValuesMethod = MethodHandles.lookup().findVirtual(specClass, "getValues", getValuesMethodType);
            isLoadedMethod = MethodHandles.lookup().findVirtual(specClass, "isLoaded", isLoadedMethodType);
            saveMethod = MethodHandles.lookup().findVirtual(specClass, "save", saveMethodType);
        }
        catch (Throwable e) {
            Loader.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (getValuesMethod != null && isLoadedMethod != null && saveMethod != null) {
            cachedConfigSpecClasses.put(specClass, true);
            configSpecMethodHandles.put(specClass, List.of(getValuesMethod, isLoadedMethod, saveMethod));
        } else {
            cachedConfigSpecClasses.put(specClass, false);
        }
    }

    public static void makeValueToDataMap(UnmodifiableConfig spec, UnmodifiableConfig values, CommentedConfig comments, Map<Object, IEntryData> allData, String basePath) {
        for (String path : values.valueMap().keySet()) {
            ForgeConfigSpec.ConfigValue configValue;
            Object data;
            String currentPath = basePath.isEmpty() ? path : basePath + "." + path;
            Object value = values.valueMap().get(path);
            if (value instanceof UnmodifiableConfig) {
                UnmodifiableConfig category = (UnmodifiableConfig)value;
                data = new EntryData.CategoryEntryData(path, category, comments.getComment(path));
                allData.put(category, (IEntryData)data);
                ConfigMenusForgeHelper.makeValueToDataMap(spec, category, (CommentedConfig)comments.valueMap().get(path), allData, currentPath);
                continue;
            }
            if (value instanceof ForgeConfigSpec.ConfigValue && (data = (configValue = (ForgeConfigSpec.ConfigValue)value).get()) instanceof UnmodifiableConfig) {
                UnmodifiableConfig category = (UnmodifiableConfig)data;
                data = new DynamicCategoryEntryData(path, category, comments.getComment(path));
                allData.put(category, (IEntryData)data);
                ConfigMenusForgeHelper.makeValueToDataMap(spec, category, (CommentedConfig)comments.valueMap().get(path), allData, currentPath);
                continue;
            }
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue2 = (ForgeConfigSpec.ConfigValue)value;
                data = new EntryData.ConfigEntryData(path, configValue2, (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue2.getPath()));
                allData.put(configValue2, (IEntryData)data);
                continue;
            }
            if (value instanceof ForgeConfigSpec.ConfigValue || !allData.containsKey(values) || !(allData.get(values) instanceof DynamicCategoryEntryData)) continue;
            data = new DynamicConfigEntryData(List.of(currentPath.split("\\.")), value, (ForgeConfigSpec.ValueSpec)spec.getRaw(currentPath), spec);
            allData.put(value, (IEntryData)data);
        }
    }

    public static class DynamicCategoryEntryData
    extends EntryData.CategoryEntryData {
        public DynamicCategoryEntryData(String path, UnmodifiableConfig config, String comment) {
            super(path, config, comment);
        }
    }

    public static class DynamicConfigEntryData<T>
    extends EntryData.ConfigEntryData<T> {
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private T currentValue;
        private T configValue;
        private final List<String> fullPath;
        private final UnmodifiableConfig spec;
        private static final ForgeConfigSpec.ConfigValue<?> dummyConfigValue = (ForgeConfigSpec.ConfigValue)UnsafeHacks.newInstance(ForgeConfigSpec.ConfigValue.class);
        private Component title;

        public DynamicConfigEntryData(List<String> fullPath, T configValue, ForgeConfigSpec.ValueSpec valueSpec, UnmodifiableConfig spec) {
            super(fullPath.get(fullPath.size() - 1), dummyConfigValue, valueSpec);
            this.configValue = configValue;
            this.currentValue = configValue;
            this.valueSpec = valueSpec;
            this.fullPath = fullPath;
            this.spec = spec;
            this.title = new TextComponent(this.getPath());
        }

        public Component getTitle() {
            return this.title;
        }

        public boolean mayResetValue() {
            return !DynamicConfigEntryData.listSafeEquals(this.currentValue, this.getDefaultValue());
        }

        public boolean mayDiscardChanges() {
            return DynamicConfigEntryData.listSafeEquals(this.configValue, this.currentValue);
        }

        private static <T> boolean listSafeEquals(T o1, T o2) {
            if (o1 instanceof List) {
                List list1 = (List)o1;
                if (o2 instanceof List) {
                    List list2 = (List)o2;
                    Stream<String> stream1 = list1.stream().map(o -> {
                        String string;
                        if (o instanceof Enum) {
                            Enum e = (Enum)o;
                            string = e.name();
                        } else {
                            string = o.toString();
                        }
                        return string;
                    });
                    Stream<String> stream2 = list2.stream().map(o -> {
                        String string;
                        if (o instanceof Enum) {
                            Enum e = (Enum)o;
                            string = e.name();
                        } else {
                            string = o.toString();
                        }
                        return string;
                    });
                    return Iterators.elementsEqual(stream1.iterator(), stream2.iterator());
                }
            }
            return Objects.equal(o1, o2);
        }

        public void resetCurrentValue() {
            this.currentValue = this.getDefaultValue();
        }

        public void discardCurrentValue() {
            this.currentValue = this.configValue;
        }

        public void saveConfigValue() {
            try {
                Field childConfigField = this.spec.getClass().getDeclaredField("childConfig");
                Config childConfig = (Config)UnsafeHacks.getField((Field)childConfigField, (Object)this.spec);
                childConfig.set(this.fullPath, this.currentValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configValue = this.currentValue;
        }

        public T getDefaultValue() {
            return (T)this.valueSpec.getDefault();
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(T newValue) {
            this.currentValue = newValue;
        }

        public List<String> getFullPath() {
            return this.fullPath;
        }

        static {
            try {
                Field specField = ForgeConfigSpec.ConfigValue.class.getDeclaredField("spec");
                UnsafeHacks.setField((Field)specField, dummyConfigValue, (Object)UnsafeHacks.newInstance(ForgeConfigSpec.class));
                Field defaultSupplierField = ForgeConfigSpec.ConfigValue.class.getDeclaredField("defaultSupplier");
                UnsafeHacks.setField((Field)defaultSupplierField, dummyConfigValue, () -> null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

