/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.update;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.silverminer.shrines.update.RVMUpdate;
import com.silverminer.shrines.update.SDUpdate;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class Updater {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void updateAll(Path oldPacketPath, Path newPacketPath) {
        try {
            Files.walk(oldPacketPath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> !p.equals(oldPacketPath)).forEach(packDirectory -> {
                String packName = packDirectory.getFileName().toString();
                Path newPackDirectory = newPacketPath.resolve(packName);
                try {
                    if (!Files.exists(newPackDirectory, new LinkOption[0])) {
                        Object author;
                        Files.createDirectories(newPackDirectory, new FileAttribute[0]);
                        try {
                            Path packageInfoPath = packDirectory.resolve("package-info.json");
                            String packageInfo = Files.readString(packageInfoPath);
                            JsonElement jsonPackageInfo = JsonParser.parseString((String)packageInfo);
                            String plainAuthor = jsonPackageInfo.getAsJsonObject().get("author").getAsString();
                            author = " created by " + plainAuthor;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            author = "";
                        }
                        Path packInfoPath = newPackDirectory.resolve("pack.mcmeta");
                        Files.writeString(packInfoPath, (CharSequence)"{\n    \"pack\": {\n        \"description\": \"Updated Shrines Structures package$author\",\n        \"pack_format\": 9\n    }\n}\n".replace("$author", (CharSequence)author), new OpenOption[0]);
                    }
                    Path dataDirectory = packDirectory.resolve("data");
                    Files.walk(dataDirectory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> !p.equals(dataDirectory)).forEach(nameSpacePath -> {
                        String namespace = nameSpacePath.getFileName().toString();
                        Path newNameSpacePath = newPackDirectory.resolve("data").resolve(namespace);
                        try {
                            Updater.copyNamespace(nameSpacePath, newNameSpacePath);
                            Updater.update(nameSpacePath, newNameSpacePath, Path.of("shrines", "worldgen", "variation_material"), Path.of("shrines", "random_variation", "material"), RVMUpdate::update);
                            SDUpdate.updateStructureData(nameSpacePath, newNameSpacePath, namespace);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyNamespace(@NotNull Path nameSpacePath, @NotNull Path newNameSpacePath) throws IOException {
        Files.walk(nameSpacePath, 1, new FileVisitOption[0]).forEach(path -> {
            if (!(path.equals(nameSpacePath) || path.endsWith("shrines") || path.endsWith("shrines_structures"))) {
                try {
                    FileUtils.copyDirectoryStructure((File)path.toFile(), (File)newNameSpacePath.resolve(nameSpacePath.relativize((Path)path)).toFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void update(@NotNull Path nameSpacePath, @NotNull Path newNameSpacePath, Path oldRelativePath, Path newRelativePath, Function<JsonElement, JsonElement> updateFunction) {
        try {
            Path oldElement = nameSpacePath.resolve(oldRelativePath);
            Path newElement = newNameSpacePath.resolve(newRelativePath);
            Files.walk(oldElement, Integer.MAX_VALUE, new FileVisitOption[0]).filter(p -> !p.equals(oldElement)).forEach(elementPath -> {
                Path relativeElementPath = oldElement.relativize((Path)elementPath);
                if (!Files.isDirectory(elementPath, new LinkOption[0])) {
                    Path newElementPath = newElement.resolve(relativeElementPath);
                    try {
                        String newMaterial = GSON.toJson((JsonElement)updateFunction.apply(JsonParser.parseString((String)Files.readString(elementPath))));
                        if (!Files.exists(newElementPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newElementPath.getParent(), new FileAttribute[0]);
                        }
                        Files.writeString(newElementPath, (CharSequence)newMaterial, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

