/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.spawn_criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteriaType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class NotCloseToStructureSpawnCriteria
extends SpawnCriteria {
    public static final Codec<NotCloseToStructureSpawnCriteria> CODEC = RecordCodecBuilder.create(closeToStructureSpawnCriteriaInstance -> closeToStructureSpawnCriteriaInstance.group((App)StructureSet.f_210002_.fieldOf("structure_set").forGetter(NotCloseToStructureSpawnCriteria::getStructureSetHolder), (App)Codec.intRange((int)0, (int)32).fieldOf("min_chunk_distance").forGetter(NotCloseToStructureSpawnCriteria::getMinChunkDistance)).apply((Applicative)closeToStructureSpawnCriteriaInstance, NotCloseToStructureSpawnCriteria::new));
    private final Holder<StructureSet> structureSetHolder;
    private final int minChunkDistance;

    public NotCloseToStructureSpawnCriteria(Holder<StructureSet> structureSetHolder, int minChunkDistance) {
        this.structureSetHolder = structureSetHolder;
        this.minChunkDistance = minChunkDistance;
    }

    private static boolean hasFeatureChunkInRange(StructureSet structureSet, int chunkX, int chunkZ, int range, ChunkGenerator chunkGenerator) {
        if (structureSet != null) {
            StructurePlacement structureplacement = structureSet.f_210004_();
            for (int i = chunkX - range; i <= chunkX + range; ++i) {
                for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                    if (!structureplacement.m_212129_(chunkGenerator, (long)range, i, j)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public SpawnCriteriaType getType() {
        return (SpawnCriteriaType)((Object)SpawnCriteriaTypeRegistry.NOT_CLOSE_TO_STRUCTURE.get());
    }

    @Override
    public boolean test(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        return !NotCloseToStructureSpawnCriteria.hasFeatureChunkInRange((StructureSet)this.getStructureSetHolder().m_203334_(), chunkPos.f_45578_, chunkPos.f_45579_, this.getMinChunkDistance(), chunkGenerator);
    }

    protected Holder<StructureSet> getStructureSetHolder() {
        return this.structureSetHolder;
    }

    protected int getMinChunkDistance() {
        return this.minChunkDistance;
    }
}

