/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.spawn_criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.config.ShrinesConfig;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteriaType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class MinStructureDistanceSpawnCriteria
extends SpawnCriteria {
    public static final Codec<MinStructureDistanceSpawnCriteria> CODEC = RecordCodecBuilder.create(minStructureDistanceSpawnCriteriaInstance -> minStructureDistanceSpawnCriteriaInstance.group((App)Codec.intRange((int)-1, (int)10).fieldOf("range").forGetter(MinStructureDistanceSpawnCriteria::getRange)).apply((Applicative)minStructureDistanceSpawnCriteriaInstance, MinStructureDistanceSpawnCriteria::new));
    private final int range;

    public MinStructureDistanceSpawnCriteria(int range) {
        this.range = range;
    }

    @Override
    public SpawnCriteriaType getType() {
        return (SpawnCriteriaType)((Object)SpawnCriteriaTypeRegistry.MIN_STRUCTURE_DISTANCE.get());
    }

    @Override
    public boolean test(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        int range;
        int n = range = this.getRange() >= 0 ? this.getRange() : ((Integer)ShrinesConfig.min_structure_distance.get()).intValue();
        if (range < 0) {
            return true;
        }
        return registryAccess.m_175515_(Registry.f_211073_).m_6579_().stream().filter(structureSet -> chunkGenerator.m_212265_((ResourceKey)structureSet.getKey(), seed, chunkPos.f_45578_, chunkPos.f_45579_, range)).count() <= (long)range;
    }

    protected int getRange() {
        return this.range;
    }
}

