/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.spawn_criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.SpawnCriteriaType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class GroundLevelDeltaSpawnCriteria
extends SpawnCriteria {
    public static final Codec<GroundLevelDeltaSpawnCriteria> CODEC = RecordCodecBuilder.create(groundLevelDeltaSpawnCriteriaInstance -> groundLevelDeltaSpawnCriteriaInstance.group((App)Codec.DOUBLE.fieldOf("delta").forGetter(GroundLevelDeltaSpawnCriteria::getDelta), (App)Codec.INT.fieldOf("check_size").forGetter(GroundLevelDeltaSpawnCriteria::getCheckSize)).apply((Applicative)groundLevelDeltaSpawnCriteriaInstance, GroundLevelDeltaSpawnCriteria::new));
    private final double delta;
    private final int checkSize;

    public GroundLevelDeltaSpawnCriteria(double delta, int checkSize) {
        this.delta = delta;
        this.checkSize = checkSize;
    }

    @Override
    public SpawnCriteriaType getType() {
        return (SpawnCriteriaType)((Object)SpawnCriteriaTypeRegistry.GROUND_LEVEL_DELTA.get());
    }

    @Override
    public boolean test(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        int[] corners = this.getCornerHeights(chunkPos.m_45604_() - this.getCheckSize() / 2, chunkPos.m_45605_() - this.getCheckSize() / 2, chunkPos.m_45604_() + this.getCheckSize() / 2, chunkPos.m_45605_() + this.getCheckSize() / 2, chunkGenerator, heightAccessor);
        int sum = 0;
        for (int i : corners) {
            sum += i;
        }
        double average = (double)sum / (double)corners.length;
        double delta = average - (double)Math.min(Math.min(corners[0], corners[1]), Math.min(corners[2], corners[3]));
        return delta < this.getDelta();
    }

    private int[] getCornerHeights(int x0, int z0, int x1, int z1, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor) {
        return new int[]{chunkGenerator.m_156179_(x0, x1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor), chunkGenerator.m_156179_(x0, x1 + z1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor), chunkGenerator.m_156179_(x0 + z0, x1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor), chunkGenerator.m_156179_(x0 + z0, x1 + z1, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor)};
    }

    protected double getDelta() {
        return this.delta;
    }

    protected int getCheckSize() {
        return this.checkSize;
    }
}

