/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.structures.placement_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.registries.PlacementCalculatorTypeRegistry;
import com.silverminer.shrines.structures.placement_types.PlacementCalculator;
import com.silverminer.shrines.structures.placement_types.PlacementCalculatorType;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class RelativePlacementCalculator
extends PlacementCalculator {
    public static final Codec<RelativePlacementCalculator> CODEC = RecordCodecBuilder.create(relativePlacementCalculatorInstance -> relativePlacementCalculatorInstance.group((App)Codec.INT.fieldOf("offset").forGetter(RelativePlacementCalculator::getOffset), (App)Heightmap.Types.f_64274_.optionalFieldOf("heightmap", (Object)Heightmap.Types.WORLD_SURFACE_WG).forGetter(RelativePlacementCalculator::getHeightmap)).apply((Applicative)relativePlacementCalculatorInstance, RelativePlacementCalculator::new));
    private final int offset;
    private final Heightmap.Types heightmap;

    public RelativePlacementCalculator(int offset) {
        this(offset, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public RelativePlacementCalculator(int offset, Heightmap.Types heightmap) {
        this.offset = offset;
        this.heightmap = heightmap;
    }

    @Override
    public PlacementCalculatorType getType() {
        return (PlacementCalculatorType)((Object)PlacementCalculatorTypeRegistry.RELATIVE.get());
    }

    @Override
    public int calculate(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, ChunkPos chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, StructureManager structureManager, RegistryAccess registryAccess) {
        return this.getOffset() + chunkGenerator.m_156174_(chunkPos.f_45578_, chunkPos.f_45579_, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
    }

    @Override
    public boolean isRelativeToWorldHeight() {
        return false;
    }

    private int getOffset() {
        return this.offset;
    }

    private Heightmap.Types getHeightmap() {
        return this.heightmap;
    }
}

