/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.registries;

import com.mojang.datafixers.util.Pair;
import com.silverminer.shrines.Shrines;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class StructureSetRegistry {
    public static final DeferredRegister<StructureSet> REGISTRY = DeferredRegister.create((ResourceKey)Registry.f_211073_, (String)"shrines");
    public static final RegistryObject<StructureSet> ABANDONED_WITCH_HOUSE = StructureSetRegistry.create("abandoned_witch_house", 60, 23, 1721882513);
    public static final RegistryObject<StructureSet> BALLOON = StructureSetRegistry.create("balloon", 50, 8, 143665);
    public static final RegistryObject<StructureSet> AZALEA_PAVILION = StructureSetRegistry.create("azalea_pavilion", 40, 16, 635166686);
    public static final RegistryObject<StructureSet> BEES = StructureSetRegistry.create("bees", 70, 12, 779806245);
    public static final RegistryObject<StructureSet> END_TEMPLE = StructureSetRegistry.create("end_temple", 60, 11, 478360);
    public static final RegistryObject<StructureSet> GUARDIAN_MEETING = StructureSetRegistry.create("guardian_meeting", 70, 17, 1498473232);
    public static final RegistryObject<StructureSet> HARBOUR = StructureSetRegistry.create("harbour", 50, 8, 651398043);
    public static final RegistryObject<StructureSet> TEMPLES = StructureSetRegistry.create("temples", 56, 25, 536987987, List.of(Pair.of((Object)"small_temple", (Object)3), Pair.of((Object)"high_temple", (Object)3), Pair.of((Object)"flooded_temple", (Object)4), Pair.of((Object)"mineral_temple", (Object)4), Pair.of((Object)"mayan_temple", (Object)3)));
    public static final RegistryObject<StructureSet> JUNGLE_TOWER = StructureSetRegistry.create("jungle_tower", 60, 11, 987531843);
    public static final RegistryObject<StructureSet> MODERN_VILLA = StructureSetRegistry.create("modern_villa", 55, 30, 688286800, List.of(Pair.of((Object)"modern_villa", (Object)5), Pair.of((Object)"abandoned_villa", (Object)3), Pair.of((Object)"luxury_villa", (Object)4)));
    public static final RegistryObject<StructureSet> NETHER_PYRAMID = StructureSetRegistry.create("nether_pyramid", 150, 50, 7428394, "nether_pyramid_overworld", "nether_pyramid_nether");
    public static final RegistryObject<StructureSet> NETHER_SHRINE = StructureSetRegistry.create("nether_shrine", 80, 15, 653267, "nether_shrine_overworld", "nether_shrine_nether");
    public static final RegistryObject<StructureSet> OASIS_SHRINE = StructureSetRegistry.create("oasis_shrine", 40, 32, 2056047070);
    public static final RegistryObject<StructureSet> ORIENTAL_HUT = StructureSetRegistry.create("oriental_hut", 32, 14, 42384446);
    public static final RegistryObject<StructureSet> ORIENTAL_SANCTUARY = StructureSetRegistry.create("oriental_sanctuary", 50, 21, 143665);
    public static final RegistryObject<StructureSet> PLAYER_HOUSE = StructureSetRegistry.create("player_house", 80, 27, 751963298, "small_player_house", "tall_player_house");
    public static final RegistryObject<StructureSet> INFESTED_PRISON = StructureSetRegistry.create("infested_prison", 60, 22, 567483014);
    public static final RegistryObject<StructureSet> SHRINE_OF_SAVANNA = StructureSetRegistry.create("shrine_of_savanna", 67, 22, 432333099);
    public static final RegistryObject<StructureSet> TRADER_HOUSE = StructureSetRegistry.create("trader_house", 60, 18, 760055678);
    public static final RegistryObject<StructureSet> WATCH_TOWER = StructureSetRegistry.create("watch_tower", 77, 16, 432189012);
    public static final RegistryObject<StructureSet> WATER_SHRINE = StructureSetRegistry.create("water_shrine", 80, 15, 643168754);
    public static final RegistryObject<StructureSet> WORLD_TREE_MANOR = StructureSetRegistry.create("world_tree_manor", 55, 45, 14944438);

    private static RegistryObject<StructureSet> create(String structureName, int spacing, int separation, int seed) {
        return StructureSetRegistry.create(structureName, spacing, separation, seed, structureName);
    }

    private static RegistryObject<StructureSet> create(String structureName, int spacing, int separation, int seed, String ... configuredStructureFeatures) {
        ArrayList<Pair<String, Integer>> structureFeatures = new ArrayList<Pair<String, Integer>>(configuredStructureFeatures.length);
        for (String s : configuredStructureFeatures) {
            structureFeatures.add((Pair<String, Integer>)Pair.of((Object)s, (Object)1));
        }
        return StructureSetRegistry.create(structureName, spacing, separation, seed, structureFeatures);
    }

    private static RegistryObject<StructureSet> create(String setName, int spacing, int separation, int seed, List<Pair<String, Integer>> configuredStructureFeatures) {
        return REGISTRY.register(setName, () -> new StructureSet(configuredStructureFeatures.stream().map(configuredStructureFeature -> new StructureSet.StructureSelectionEntry((Holder)Holder.Reference.m_205766_((Registry)BuiltinRegistries.f_123862_, (ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)Shrines.location((String)configuredStructureFeature.getFirst()))), ((Integer)configuredStructureFeature.getSecond()).intValue())).toList(), (StructurePlacement)new RandomSpreadStructurePlacement(spacing, separation, RandomSpreadType.LINEAR, seed)));
    }
}

