/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.random_variation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.Shrines;
import com.silverminer.shrines.random_variation.RandomVariationConfigElement;
import com.silverminer.shrines.random_variation.RandomVariationMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomVariationConfig
extends ForgeRegistryEntry<RandomVariationConfig> {
    public static final ResourceKey<? extends Registry<RandomVariationConfig>> REGISTRY = ResourceKey.m_135788_((ResourceLocation)Shrines.location("random_variation/config"));
    public static final Codec<RandomVariationConfig> DIRECT_CODEC = RecordCodecBuilder.create(randomVariationConfigInstance -> randomVariationConfigInstance.group((App)Codec.list((Codec)Codec.list(RandomVariationConfigElement.CODEC)).fieldOf("remaps").forGetter(RandomVariationConfig::remaps)).apply((Applicative)randomVariationConfigInstance, RandomVariationConfig::new));
    public static final Codec<Holder<RandomVariationConfig>> CODEC = RegistryFileCodec.m_135589_(REGISTRY, DIRECT_CODEC);
    private final List<List<RandomVariationConfigElement>> remaps;

    public RandomVariationConfig(List<List<RandomVariationConfigElement>> remaps) {
        this.remaps = remaps;
    }

    public List<List<RandomVariationConfigElement>> remaps() {
        return this.remaps;
    }

    public void process(@NotNull WorldGenLevel worldGenLevel, @NotNull Random random, @NotNull BoundingBox chunkBounds, @NotNull BoundingBox structureBounds, Predicate<BlockPos> isInside) {
        List<RandomVariationConfigElement> unmappedRemaps = this.random(this.remaps(), random);
        if (unmappedRemaps == null) {
            return;
        }
        ArrayList mappedRemaps = new ArrayList();
        for (RandomVariationConfigElement e : unmappedRemaps) {
            for (Holder holder : e.from()) {
                e.to().m_203450_(random).ifPresent(destinationHolder -> mappedRemaps.add(Pair.of((Object)((Object)((RandomVariationMaterial)((Object)((Object)holder.m_203334_())))), (Object)((Object)((RandomVariationMaterial)((Object)((Object)destinationHolder.m_203334_())))))));
            }
        }
        for (int x = chunkBounds.m_162395_(); x <= chunkBounds.m_162399_(); ++x) {
            for (int y = chunkBounds.m_162396_(); y <= chunkBounds.m_162400_(); ++y) {
                block4: for (int z = chunkBounds.m_162398_(); z <= chunkBounds.m_162401_(); ++z) {
                    for (Pair remapPair : mappedRemaps) {
                        Optional<BlockState> newBlockState;
                        BlockPos position;
                        if (remapPair.getSecond() == null || worldGenLevel.m_46859_(position = new BlockPos(x, y, z)) || !structureBounds.m_71051_((Vec3i)position) || !isInside.test(position)) continue;
                        BlockState blockStateAtPos = worldGenLevel.m_8055_(position);
                        Optional<ResourceLocation> id = this.find(((RandomVariationMaterial)((Object)remapPair.getFirst())).elements(), elementPair -> ((Block)elementPair.getFirst()).equals(blockStateAtPos.m_60734_())).map(Pair::getSecond);
                        if (id.isEmpty() || (newBlockState = this.find(((RandomVariationMaterial)((Object)remapPair.getSecond())).elements(), elementPair -> ((ResourceLocation)elementPair.getSecond()).equals(id.get())).map(Pair::getFirst).map(block -> block.m_152465_(blockStateAtPos))).isEmpty()) continue;
                        worldGenLevel.m_7731_(position, newBlockState.get(), 18);
                        continue block4;
                    }
                }
            }
        }
    }

    @Nullable
    private <T> T random(@NotNull List<T> list, Random r) {
        if (list.isEmpty()) {
            return null;
        }
        int size = list.size();
        return list.get(r.nextInt(size));
    }

    @NotNull
    private <T> Optional<T> find(@NotNull List<T> list, Predicate<T> matcher) {
        for (T t : list) {
            if (!matcher.test(t)) continue;
            return Optional.ofNullable(t);
        }
        return Optional.empty();
    }
}

