/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.mixins;

import com.mojang.datafixers.util.Pair;
import com.silverminer.shrines.commands.LocateInBiomeChunkGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ChunkGenerator.class})
public abstract class MixinChunkGenerator
implements LocateInBiomeChunkGenerator {
    @Shadow
    @Final
    protected BiomeSource f_62138_;

    @Shadow
    protected abstract List<StructurePlacement> m_208090_(Holder<ConfiguredStructureFeature<?, ?>> var1);

    @Shadow
    @Nullable
    protected abstract BlockPos m_204382_(BlockPos var1, ConcentricRingsStructurePlacement var2);

    @Override
    public Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> findNearestMapFeature(ServerLevel pLevel, HolderSet<ConfiguredStructureFeature<?, ?>> pStructureSet, BlockPos pPos, int pSearchRadius, boolean pSkipKnownStructures, Predicate<Holder<Biome>> biomeHolderPredicate) {
        Set set = pStructureSet.m_203614_().flatMap(p_211699_ -> ((ConfiguredStructureFeature)p_211699_.m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return null;
        }
        Set set1 = this.f_62138_.m_207840_();
        if (Collections.disjoint(set1, set) || set.stream().noneMatch(biomeHolderPredicate)) {
            return null;
        }
        Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> pair = null;
        double d0 = Double.MAX_VALUE;
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Object holder : pStructureSet) {
            if (!set1.stream().anyMatch(arg_0 -> ((HolderSet)((ConfiguredStructureFeature)holder.m_203334_()).m_209752_()).m_203333_(arg_0))) continue;
            for (StructurePlacement structureplacement : this.m_208090_((Holder<ConfiguredStructureFeature<?, ?>>)holder)) {
                map.computeIfAbsent(structureplacement, p_211663_ -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement1 = (StructurePlacement)entry.getKey();
            if (structureplacement1 instanceof ConcentricRingsStructurePlacement) {
                double d1;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement1;
                BlockPos blockpos = this.m_204382_(pPos, concentricringsstructureplacement);
                if (blockpos == null || !((d1 = pPos.m_123331_((Vec3i)blockpos)) < d0) || !biomeHolderPredicate.test((Holder<Biome>)pLevel.m_204166_(blockpos))) continue;
                d0 = d1;
                pair = Pair.of((Object)blockpos, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!(structureplacement1 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int i = SectionPos.m_123171_((int)pPos.m_123341_());
            int j = SectionPos.m_123171_((int)pPos.m_123343_());
            for (int k = 0; k <= pSearchRadius; ++k) {
                boolean flag = false;
                for (Map.Entry entry1 : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry1.getKey();
                    Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> pair1 = MixinChunkGenerator.getNearestGeneratedStructure((Set)entry1.getValue(), (LevelReader)pLevel, pLevel.m_8595_(), i, j, k, pSkipKnownStructures, pLevel.m_7328_(), randomspreadstructureplacement, biomeHolderPredicate);
                    if (pair1 == null) continue;
                    flag = true;
                    double d2 = pPos.m_123331_((Vec3i)pair1.getFirst());
                    if (!(d2 < d0)) continue;
                    d0 = d2;
                    pair = pair1;
                }
                if (!flag) continue;
                return pair;
            }
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> getNearestGeneratedStructure(Set<Holder<ConfiguredStructureFeature<?, ?>>> p_208060_, LevelReader levelReader, StructureFeatureManager p_208062_, int p_208063_, int p_208064_, int p_208065_, boolean p_208066_, long p_208067_, @NotNull RandomSpreadStructurePlacement p_208068_, Predicate<Holder<Biome>> biomeHolderPredicate) {
        int i = p_208068_.f_204973_();
        for (int j = -p_208065_; j <= p_208065_; ++j) {
            boolean flag = j == -p_208065_ || j == p_208065_;
            for (int k = -p_208065_; k <= p_208065_; ++k) {
                int i1;
                int l;
                ChunkPos chunkpos;
                boolean flag1;
                boolean bl = flag1 = k == -p_208065_ || k == p_208065_;
                if (!flag && !flag1 || !biomeHolderPredicate.test((Holder<Biome>)levelReader.m_204166_((chunkpos = p_208068_.m_204991_(p_208067_, l = p_208063_ + i * j, i1 = p_208064_ + i * k)).m_151394_(0)))) continue;
                for (Holder<ConfiguredStructureFeature<?, ?>> holder : p_208060_) {
                    StructureCheckResult structurecheckresult = p_208062_.m_207777_(chunkpos, (ConfiguredStructureFeature)holder.m_203334_(), p_208066_);
                    if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!p_208066_ && structurecheckresult == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)StructureFeature.m_204766_((RandomSpreadStructurePlacement)p_208068_, (ChunkPos)chunkpos), holder);
                    }
                    ChunkAccess chunkaccess = levelReader.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
                    StructureStart structurestart = p_208062_.m_207802_(SectionPos.m_175562_((ChunkAccess)chunkaccess), (ConfiguredStructureFeature)holder.m_203334_(), (FeatureAccess)chunkaccess);
                    if (structurestart == null || !structurestart.m_73603_()) continue;
                    if (p_208066_ && structurestart.m_73606_()) {
                        p_208062_.m_196674_(structurestart);
                        return Pair.of((Object)StructureFeature.m_204766_((RandomSpreadStructurePlacement)p_208068_, (ChunkPos)structurestart.m_163625_()), holder);
                    }
                    if (p_208066_) continue;
                    return Pair.of((Object)StructureFeature.m_204766_((RandomSpreadStructurePlacement)p_208068_, (ChunkPos)structurestart.m_163625_()), holder);
                }
            }
        }
        return null;
    }
}

