/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaguya.ash_of_sin_custom_anti_trap_cage_entity.events;

import com.kamikaguya.ash_of_sin_custom_anti_trap_cage_entity.config.CustomAntiTrapCageEntityConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ash_of_sin_custom_anti_trap_cage_entity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AshOfSinCustomAntiTrapCageEntityEvent {
    private static final int DISTANCE = (Integer)CustomAntiTrapCageEntityConfig.CHECK_DISTANCE.get();

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (((Boolean)CustomAntiTrapCageEntityConfig.ANTI_ON.get()).booleanValue()) {
            if (event.getEntityLiving().f_19853_.m_5776_()) {
                return;
            }
            LivingEntity livingEntity = event.getEntityLiving();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            Level world = player.f_19853_;
            double playerX = player.m_20185_();
            double playerY = player.m_20186_();
            double playerZ = player.m_20189_();
            List<String> customAntiTrapCageEntityList = ((List)CustomAntiTrapCageEntityConfig.ANTI_TRAP_CAGE_ENTITY.get()).stream().map(s -> s).toList();
            for (String entityName : customAntiTrapCageEntityList) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityName));
                if (entityType == null) continue;
                List nearbyEntities = world.m_45976_(LivingEntity.class, new AABB(playerX - (double)DISTANCE, playerY - 8.0, playerZ - (double)DISTANCE, playerX + (double)DISTANCE, playerY + 8.0, playerZ + (double)DISTANCE));
                for (LivingEntity nearbyEntity : nearbyEntities) {
                    if (!entityType.equals(nearbyEntity.m_6095_())) continue;
                    AshOfSinCustomAntiTrapCageEntityEvent.breakTrapCageIfInDistance(world, nearbyEntity);
                }
            }
        }
    }

    private static void breakTrapCageIfInDistance(Level world, LivingEntity entity) {
        Block trapCageBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("untamedwilds:trap_cage"));
        if (trapCageBlock == null) {
            return;
        }
        AABB entityBoundingBox = new AABB(entity.m_20185_() - (double)DISTANCE, entity.m_20186_() - 1.0, entity.m_20189_() - (double)DISTANCE, entity.m_20185_() + (double)DISTANCE, entity.m_20186_() + 1.0, entity.m_20189_() + (double)DISTANCE);
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)new BlockPos(entityBoundingBox.f_82288_, entityBoundingBox.f_82289_, entityBoundingBox.f_82290_), (BlockPos)new BlockPos(entityBoundingBox.f_82291_, entityBoundingBox.f_82292_, entityBoundingBox.f_82293_))) {
            BlockState blockState;
            if (world.m_46859_(blockPos) || !(blockState = world.m_8055_(blockPos)).m_60713_(trapCageBlock)) continue;
            world.m_46961_(blockPos, true);
        }
    }
}

