/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.config;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.common.ForgeConfigSpec;

public class SpawnConfig {
    private final ForgeConfigSpec.BooleanValue allowNormalSpawn;
    private final ForgeConfigSpec.BooleanValue allowSpawners;
    private final ForgeConfigSpec.BooleanValue allowSpawnEggs;
    private final ForgeConfigSpec.BooleanValue allowConversions;
    private final ForgeConfigSpec.BooleanValue removeAggresively;

    public SpawnConfig(ResourceLocation id, ForgeConfigSpec.Builder builder) {
        builder.comment("Options for the " + id.m_135827_() + " mod.");
        builder.push(id.m_135827_());
        builder.comment("Spawning options for " + id.toString());
        builder.push(id.m_135815_());
        builder.comment("Should the entity be allowed to spawn normally?");
        this.allowNormalSpawn = builder.define("allowNormalSpawning", true);
        builder.comment("Should spawners be able to spawn the entity?");
        this.allowSpawners = builder.define("allowSpawners", true);
        builder.comment("Should spawn eggs be able to spawn the entity?");
        this.allowSpawnEggs = builder.define("allowSpawnEggs", true);
        builder.comment("Should the entity spawn via mob conversion? i.e. villager -> zombie");
        this.allowConversions = builder.define("allowConversions", true);
        builder.comment("When enabled the entity type will be aggresively removed from worlds. This will bypass all other options.");
        this.removeAggresively = builder.define("removeAggressively", false);
        builder.pop();
        builder.pop();
    }

    public boolean canSpawn(MobSpawnType reason) {
        if (((Boolean)this.removeAggresively.get()).booleanValue()) {
            return false;
        }
        if (reason == MobSpawnType.SPAWNER) {
            return (Boolean)this.allowSpawners.get();
        }
        if (reason == MobSpawnType.SPAWN_EGG) {
            return (Boolean)this.allowSpawnEggs.get();
        }
        if (reason == MobSpawnType.CONVERSION) {
            return (Boolean)this.allowConversions.get();
        }
        return (Boolean)this.allowNormalSpawn.get();
    }
}

