/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.packs;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.NativeImage;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.tinyskeletons.client.renderer.entity.BabySkeletonRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyStrayRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyWitherSkeletonRenderer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class BabySkeletonPackResources
extends AbstractModPackResources {
    private static final ResourceLocation SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private static final ResourceLocation STRAY_SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/stray.png");
    private static final ResourceLocation WITHER_SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/wither_skeleton.png");
    private static final BiMap<ResourceLocation, ResourceLocation> BABY_SKELETON_LOCATIONS = ImmutableBiMap.of((Object)BabySkeletonRenderer.BABY_SKELETON_LOCATION, (Object)SKELETON_LOCATION, (Object)BabyStrayRenderer.BABY_STRAY_SKELETON_LOCATION, (Object)STRAY_SKELETON_LOCATION, (Object)BabyWitherSkeletonRenderer.BABY_WITHER_SKELETON_LOCATION, (Object)WITHER_SKELETON_LOCATION);
    private static final int VANILLA_SKELETON_TEXTURE_WIDTH = 64;
    private static final int VANILLA_SKELETON_TEXTURE_HEIGHT = 32;
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;

    public BabySkeletonPackResources() {
        Minecraft minecraft = Minecraft.m_91087_();
        this.resourceManager = minecraft.m_91098_();
        this.vanillaPackResources = minecraft.m_91100_().m_118555_();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public InputStream m_8031_(PackType packType, ResourceLocation location) throws IOException {
        ResourceLocation vanillaSkeletonLocation = (ResourceLocation)BABY_SKELETON_LOCATIONS.get((Object)location);
        if (vanillaSkeletonLocation == null) {
            throw new FileNotFoundException(location.m_135815_());
        }
        try (NativeImage image = NativeImage.m_85058_((InputStream)this.resourceManager.m_142591_(vanillaSkeletonLocation).m_6679_());){
            if (image.m_84982_() / image.m_85084_() == 2) return this.resourceManager.m_142591_(vanillaSkeletonLocation).m_6679_();
            InputStream inputStream = this.vanillaPackResources.m_8031_(packType, vanillaSkeletonLocation);
            return inputStream;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.resourceManager.m_142591_(vanillaSkeletonLocation).m_6679_();
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        return BABY_SKELETON_LOCATIONS.containsKey((Object)location);
    }

    public Set<String> m_5698_(PackType type) {
        return BABY_SKELETON_LOCATIONS.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }
}

