/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.undeadrevamp.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.undeadrevamp.world.features.Bohut1Feature;
import net.mcreator.undeadrevamp.world.features.BohutlushFeature;
import net.mcreator.undeadrevamp.world.features.BohutunderaoFeature;
import net.mcreator.undeadrevamp.world.features.FlowertombFeature;
import net.mcreator.undeadrevamp.world.features.IrontombFeature;
import net.mcreator.undeadrevamp.world.features.SkellytombFeature;
import net.mcreator.undeadrevamp.world.features.ores.BostrokestoneFeature;
import net.mcreator.undeadrevamp.world.features.ores.BostroxoreFeature;
import net.mcreator.undeadrevamp.world.features.plants.ArapholiaFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class UndeadRevamp2ModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"undead_revamp2");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> ARAPHOLIA = UndeadRevamp2ModFeatures.register("arapholia", ArapholiaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, ArapholiaFeature.GENERATE_BIOMES, ArapholiaFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BOSTROKESTONE = UndeadRevamp2ModFeatures.register("bostrokestone", BostrokestoneFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BostrokestoneFeature.GENERATE_BIOMES, BostrokestoneFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BOSTROXORE = UndeadRevamp2ModFeatures.register("bostroxore", BostroxoreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BostroxoreFeature.GENERATE_BIOMES, BostroxoreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SKELLYTOMB = UndeadRevamp2ModFeatures.register("skellytomb", SkellytombFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SkellytombFeature.GENERATE_BIOMES, SkellytombFeature::placedFeature));
    public static final RegistryObject<Feature<?>> IRONTOMB = UndeadRevamp2ModFeatures.register("irontomb", IrontombFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, IrontombFeature.GENERATE_BIOMES, IrontombFeature::placedFeature));
    public static final RegistryObject<Feature<?>> FLOWERTOMB = UndeadRevamp2ModFeatures.register("flowertomb", FlowertombFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, FlowertombFeature.GENERATE_BIOMES, FlowertombFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BOHUT_1 = UndeadRevamp2ModFeatures.register("bohut_1", Bohut1Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Bohut1Feature.GENERATE_BIOMES, Bohut1Feature::placedFeature));
    public static final RegistryObject<Feature<?>> BOHUTUNDERAO = UndeadRevamp2ModFeatures.register("bohutunderao", BohutunderaoFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, BohutunderaoFeature.GENERATE_BIOMES, BohutunderaoFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BOHUTLUSH = UndeadRevamp2ModFeatures.register("bohutlush", BohutlushFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, BohutlushFeature.GENERATE_BIOMES, BohutlushFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

