/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.breed;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.github.kay9.dragonmounts.habitats.FluidHabitat;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.github.kay9.dragonmounts.habitats.NearbyBlocksHabitat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BreedRegistry {
    private static final ResourceKey<Registry<DragonBreed>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)DragonMountsLegacy.id("dragon_breeds"));
    public static final DeferredRegister<DragonBreed> DEFERRED_REGISTRY = DeferredRegister.create(REGISTRY_KEY, (String)"dragonmounts");
    public static final RegistryObject<DragonBreed> FIRE_BUILTIN = DEFERRED_REGISTRY.register("fire", () -> DragonBreed.builtInUnnamed(9511936, 16750617, Optional.of(ParticleTypes.f_123744_), new DragonBreed.ModelProperties(false, false, false), (Map<Attribute, Double>)ImmutableMap.of(), (List<Ability>)ImmutableList.of(), (List<Habitat>)ImmutableList.of((Object)new NearbyBlocksHabitat(1.0f, (TagKey<Block>)BlockTags.create((ResourceLocation)DragonMountsLegacy.id("fire_dragon_habitat_blocks"))), (Object)new FluidHabitat(3.0f, (TagKey<Fluid>)FluidTags.f_13132_)), (ImmutableSet<String>)ImmutableSet.of((Object)"onFire", (Object)"inFire", (Object)"lava", (Object)"hotFloor"), Optional.empty()));
    public static final Supplier<IForgeRegistry<DragonBreed>> REGISTRY = DEFERRED_REGISTRY.makeRegistry(DragonBreed.class, () -> new RegistryBuilder().disableSaving().dataPackRegistry(DragonBreed.CODEC, DragonBreed.NETWORK_CODEC).setDefaultKey(FIRE_BUILTIN.getId()));
    public static final Codec<DragonBreed> CODEC = ResourceLocation.f_135803_.xmap(BreedRegistry::get, ForgeRegistryEntry::getRegistryName).promotePartial(err -> DragonMountsLegacy.LOG.error("Unknown Dragon Breed Type: {}", err));

    public static DragonBreed get(String byString) {
        return BreedRegistry.get(new ResourceLocation(byString));
    }

    public static DragonBreed get(ResourceLocation byId) {
        DragonBreed breed = (DragonBreed)((Object)BreedRegistry.registry().m_7745_(byId));
        if (breed == null) {
            breed = BreedRegistry.getFallback();
        }
        return breed;
    }

    public static DragonBreed getFallback() {
        return BreedRegistry.get(FIRE_BUILTIN.getId());
    }

    public static Registry<DragonBreed> registry() {
        return (switch (FMLLoader.getDist()) {
            default -> throw new IncompatibleClassChangeError();
            case Dist.CLIENT -> {
                if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91073_ != null) {
                    yield Minecraft.m_91087_().f_91073_.m_5962_();
                }
            }
            case Dist.DEDICATED_SERVER -> ServerLifecycleHooks.getCurrentServer() != null ? ServerLifecycleHooks.getCurrentServer().m_206579_() : BuiltinRegistries.f_206379_;
        }).m_175515_(REGISTRY_KEY);
    }
}

