/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.client.DragonAnimator;
import com.github.kay9.dragonmounts.dragon.DragonEgg;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.ai.DragonBodyController;
import com.github.kay9.dragonmounts.dragon.ai.DragonBreedGoal;
import com.github.kay9.dragonmounts.dragon.ai.DragonMoveController;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TameableDragon
extends TamableAnimal
implements Saddleable,
FlyingAnimal,
PlayerRideable {
    public static final double BASE_SPEED_GROUND = 0.3;
    public static final double BASE_SPEED_FLYING = 0.525;
    public static final double BASE_DAMAGE = 8.0;
    public static final double BASE_HEALTH = 60.0;
    public static final double BASE_FOLLOW_RANGE = 16.0;
    public static final double BASE_FOLLOW_RANGE_FLYING = 32.0;
    public static final int BASE_KB_RESISTANCE = 1;
    public static final float BASE_WIDTH = 2.75f;
    public static final float BASE_HEIGHT = 2.75f;
    private static final EntityDataAccessor<String> DATA_BREED = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DATA_FLYING = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(TameableDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String NBT_BREED = "Breed";
    private static final String NBT_SADDLED = "Saddle";
    private static final String NBT_REPRO_COUNT = "ReproCount";
    public static final int AGE_UPDATE_INTERVAL = 100;
    public static final UUID SCALE_MODIFIER_UUID = UUID.fromString("856d4ba4-9ffe-4a52-8606-890bb9be538b");
    public static final int ALTITUDE_FLYING_THRESHOLD = 3;
    public static final int DEFAULT_REPRO_LIMIT = 2;
    public static final int DEFAULT_GROWTH_TIME = 72000;
    private final DragonAnimator animator;
    private DragonBreed breed;
    private int reproCount;
    private float ageProgress;

    public TameableDragon(EntityType<? extends TameableDragon> type, Level level) {
        super(type, level);
        this.f_19793_ = 1.0f;
        this.f_19811_ = true;
        this.f_21342_ = new DragonMoveController(this);
        this.animator = level.f_46443_ ? new DragonAnimator(this) : null;
        this.breed = BreedRegistry.getFallback();
    }

    @NotNull
    public BodyRotationControl m_7560_() {
        return new DragonBodyController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 16.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22280_, 0.525);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.1, 10.0f, 3.5f, true));
        this.f_21345_.m_25352_(5, (Goal)new DragonBreedGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 16.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, e -> !(e instanceof TameableDragon)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BREED, (Object)"");
        this.f_19804_.m_135372_(DATA_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DATA_BREED.equals(data)) {
            this.updateBreed(BreedRegistry.get((String)this.f_19804_.m_135370_(DATA_BREED)));
        } else if (f_21798_.equals(data)) {
            this.m_6210_();
        } else if (DATA_AGE.equals(data)) {
            this.updateAgeProperties();
        } else {
            super.m_7350_(data);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_(NBT_BREED, this.breed.getRegistryName().toString());
        compound.m_128379_(NBT_SADDLED, this.m_6254_());
        compound.m_128405_(NBT_REPRO_COUNT, this.reproCount);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBreed(BreedRegistry.get(compound.m_128461_(NBT_BREED)));
        this.setSaddled(compound.m_128471_(NBT_SADDLED));
        this.reproCount = compound.m_128451_(NBT_REPRO_COUNT);
        this.f_19804_.m_135381_(DATA_AGE, (Object)this.m_146764_());
    }

    public void setBreed(DragonBreed dragonBreed) {
        this.f_19804_.m_135381_(DATA_BREED, (Object)dragonBreed.getRegistryName().toString());
    }

    private void updateBreed(DragonBreed breed) {
        this.getBreed().close(this);
        this.breed = breed;
        this.getBreed().initialize(this);
    }

    public DragonBreed getBreed() {
        return this.breed;
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.isHatchling() && this.m_21824_();
    }

    public void m_5853_(@Nullable SoundSource source) {
        this.setSaddled(true);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12034_, this.m_5720_(), 1.0f, 1.0f);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddled);
    }

    public void addReproCount() {
        ++this.reproCount;
    }

    public boolean canFly() {
        return !this.isHatchling();
    }

    public boolean shouldFly() {
        return this.canFly() && !this.m_20069_() && this.isHighEnough(3);
    }

    public boolean m_142592_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(DATA_FLYING, (Object)flying);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isServer()) {
            boolean flying;
            if (this.f_146733_ < 0 && this.f_19797_ % 100 == 0) {
                this.f_19804_.m_135381_(DATA_AGE, (Object)this.f_146733_);
            }
            if ((flying = this.shouldFly()) != this.m_142592_()) {
                this.setFlying(flying);
                this.m_21051_(Attributes.f_22277_).m_22100_(flying ? 32.0 : 16.0);
                this.f_21344_ = flying ? new FlyingPathNavigation((Mob)this, this.f_19853_) : new GroundPathNavigation((Mob)this, this.f_19853_);
            }
        } else {
            this.animator.tick();
            int age = this.m_146764_();
            if (age < 0) {
                this.m_146762_(++age);
            } else if (age > 0) {
                this.m_146762_(--age);
            }
        }
        this.updateAgeProgress();
        for (Ability ability : this.getBreed().abilities()) {
            ability.tick(this);
        }
    }

    public void m_7023_(Vec3 vec3) {
        boolean isFlying = this.m_142592_();
        float speed = (float)this.m_21133_(isFlying ? Attributes.f_22280_ : Attributes.f_22279_) * 0.225f;
        if (this.m_5807_()) {
            LivingEntity driver = (LivingEntity)this.m_6688_();
            double moveSideways = vec3.f_82479_;
            double moveY = vec3.f_82480_;
            double moveForward = Math.min(Math.abs(driver.f_20902_) + Math.abs(driver.f_20900_), 1.0f);
            float yaw = driver.f_20885_;
            if (moveForward > 0.0) {
                yaw += (float)Mth.m_14136_((double)driver.f_20902_, (double)driver.f_20900_) * 57.295776f - 90.0f;
            }
            this.f_20885_ = yaw;
            this.m_146926_(driver.m_146909_() * 0.68f);
            this.m_146922_(Mth.m_14094_((float)this.f_20885_, (float)this.m_146908_(), (float)4.0f));
            if (this.m_6109_()) {
                if (isFlying) {
                    double d = moveForward = moveForward > 0.0 ? moveForward : 0.0;
                    moveY = moveForward > 0.0 && DMLConfig.cameraFlight() ? (double)(-driver.m_146909_()) * (Math.PI / 180) : (driver.f_20899_ ? 1.0 : (DMLRegistry.FLIGHT_DESCENT_KEY.getAsBoolean() ? -1.0 : 0.0));
                } else if (driver.f_20899_ && this.canFly()) {
                    this.liftOff();
                }
                vec3 = new Vec3(moveSideways, moveY, moveForward);
                this.m_7910_(speed);
            } else if (driver instanceof Player) {
                this.m_21043_((LivingEntity)this, true);
                this.m_20256_(Vec3.f_82478_);
                return;
            }
        }
        if (isFlying) {
            this.m_19920_(speed, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.m_20184_().m_82556_() < 0.1) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, Math.sin((float)this.f_19797_ / 4.0f) * 0.03, 0.0));
            }
            this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            this.m_21043_((LivingEntity)this, true);
        } else {
            super.m_7023_(vec3);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult stackResult = stack.m_41647_(player, (LivingEntity)this, hand);
        if (stackResult.m_19077_()) {
            return stackResult;
        }
        InteractionResult SUCCESS = InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (!this.m_21824_()) {
            if (this.isServer() && stack.m_204117_(this.getBreed().tamingItems())) {
                stack.m_41774_(1);
                this.tamedFor(player, this.m_21187_().nextInt(5) == 0);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.getHealthRelative() < 1.0 && this.isFoodItem(stack)) {
            this.m_5634_(stack.m_41720_().m_41473_().m_38744_());
            this.m_5496_(this.m_7866_(stack), 0.7f, 1.0f);
            stack.m_41774_(1);
            return SUCCESS;
        }
        if (this.isTamedFor(player) && this.m_6741_() && !this.m_6254_() && stack.m_41720_() instanceof SaddleItem) {
            stack.m_41774_(1);
            this.m_5853_(this.m_5720_());
            return SUCCESS;
        }
        if (this.isTamedFor(player) && (player.m_6144_() || stack.m_150930_(Items.f_42500_))) {
            if (this.isServer()) {
                this.f_21344_.m_26573_();
                this.m_21839_(!this.m_21827_());
                if (this.m_21827_()) {
                    this.m_6710_(null);
                }
            }
            return SUCCESS;
        }
        if (this.isTamedFor(player) && this.m_6254_() && !this.isHatchling() && !this.m_6898_(stack)) {
            if (this.isServer()) {
                this.setRidingPlayer(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
            this.m_21839_(false);
            this.m_21837_(false);
            return SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public double getAltitude(int limit) {
        BlockPos.MutableBlockPos pointer = this.m_142538_().m_122032_().m_122184_(0, -1, 0);
        int min = this.f_19853_.m_6042_().m_156732_();
        int i = 0;
        while (i <= limit && pointer.m_123342_() > min && !this.f_19853_.m_8055_((BlockPos)pointer).m_60767_().m_76333_()) {
            pointer.m_142448_(this.m_146904_() - ++i);
        }
        return i;
    }

    public double getAltitude() {
        return this.getAltitude(this.f_19853_.m_151558_());
    }

    public boolean isHighEnough(int height) {
        return this.getAltitude(height) >= (double)height;
    }

    public void liftOff() {
        if (this.canFly()) {
            this.m_6135_();
        }
    }

    protected float m_6118_() {
        return super.m_6118_() * (float)(this.canFly() ? 3 : 1);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return !this.canFly() && super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    protected void m_6153_() {
        this.m_20153_();
        this.m_20256_(Vec3.f_82478_);
        this.m_146922_(this.f_19859_);
        this.m_5616_(this.f_20886_);
        if (this.f_20919_ >= this.getMaxDeathTime()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        ++this.f_20919_;
    }

    protected SoundEvent m_7515_() {
        double random = this.m_21187_().nextDouble();
        if (random < 0.2) {
            return SoundEvents.f_11894_;
        }
        if (this.getBreed().specialSound().isPresent() && random < 0.5) {
            return this.getBreed().getAmbientSound();
        }
        return (SoundEvent)DMLRegistry.DRAGON_BREATHE_SOUND.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11895_;
    }

    public SoundEvent getStepSound() {
        return (SoundEvent)DMLRegistry.DRAGON_STEP_SOUND.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DMLRegistry.DRAGON_DEATH_SOUND.get();
    }

    public SoundEvent m_7866_(ItemStack itemStackIn) {
        return SoundEvents.f_11912_;
    }

    public SoundEvent getAttackSound() {
        return SoundEvents.f_11912_;
    }

    public SoundEvent getWingsSound() {
        return SoundEvents.f_11893_;
    }

    protected void m_7355_(BlockPos entityPos, BlockState state) {
        if (this.m_20069_()) {
            return;
        }
        SoundType soundType = state.m_60827_();
        if (this.f_19853_.m_8055_(entityPos.m_7494_()).m_60734_() == Blocks.f_50125_) {
            soundType = Blocks.f_50125_.getSoundType(state, (LevelReader)this.f_19853_, entityPos, (Entity)this);
        }
        SoundEvent stepSound = this.getStepSound();
        if (this.isHatchling()) {
            stepSound = soundType.m_56776_();
        }
        this.m_5496_(stepSound, soundType.m_56773_(), this.m_6100_());
    }

    public int m_8100_() {
        return 240;
    }

    protected float m_6121_() {
        return this.m_6134_();
    }

    public float m_6100_() {
        return 2.0f - this.m_6134_();
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        if (pSound == this.breed.getAmbientSound()) {
            pPitch /= 2.0f;
        }
        super.m_5496_(pSound, pVolume, pPitch);
    }

    public ItemStack getPickedResult(HitResult target) {
        return DragonSpawnEgg.create(this.getBreed());
    }

    protected Component m_5677_() {
        return new TranslatableComponent(this.getBreed().getTranslationKey());
    }

    public boolean isFoodItem(ItemStack stack) {
        return stack.m_41720_().m_41472_() && stack.m_41720_().m_41473_().m_38746_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(this.getBreed().breedingItems());
    }

    public void tamedFor(Player player, boolean successful) {
        if (successful) {
            this.m_7105_(true);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21816_(player.m_142081_());
            this.f_19853_.m_7605_((Entity)this, (byte)7);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)6);
        }
    }

    public boolean isTamedFor(Player player) {
        return this.m_21824_() && this.m_21830_((LivingEntity)player);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 1.2f;
    }

    public double m_6048_() {
        return (double)this.m_20206_() - 0.175;
    }

    public float m_6134_() {
        return 0.33f + 0.67f * this.getAgeProgress();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6147_() {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    protected ResourceLocation m_7582_() {
        return this.breed.deathLoot();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean attacked = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        if (attacked) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return attacked;
    }

    public void onWingsDown(float speed) {
        if (!this.m_20069_()) {
            float pitch = 1.0f - speed;
            float volume = 0.3f + (1.0f - speed) * 0.2f;
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getWingsSound(), SoundSource.VOICE, volume *= this.m_6121_(), pitch *= this.m_6100_(), true);
        }
    }

    public void m_6674_(InteractionHand hand) {
        this.m_5496_(this.getAttackSound(), 1.0f, 0.7f);
        super.m_6674_(hand);
    }

    public boolean m_6469_(DamageSource src, float par2) {
        if (this.m_6673_(src)) {
            return false;
        }
        this.m_21839_(false);
        return super.m_6469_(src, par2);
    }

    public boolean m_7848_(Animal mate) {
        if (mate == this) {
            return false;
        }
        if (!(mate instanceof TameableDragon)) {
            return false;
        }
        if (!this.canReproduce()) {
            return false;
        }
        TameableDragon dragonMate = (TameableDragon)mate;
        if (!dragonMate.m_21824_()) {
            return false;
        }
        if (!dragonMate.canReproduce()) {
            return false;
        }
        return this.m_27593_() && dragonMate.m_27593_();
    }

    public boolean canReproduce() {
        return this.m_21824_() && this.reproCount < DMLConfig.reproLimit();
    }

    public void m_27563_(ServerLevel level, Animal animal) {
        if (!(animal instanceof TameableDragon)) {
            DragonMountsLegacy.LOG.warn("Tried to mate with non-dragon? Hello? {}", (Object)animal);
            return;
        }
        TameableDragon mate = (TameableDragon)animal;
        DragonEgg egg = (DragonEgg)((EntityType)DMLRegistry.DRAGON_EGG.get()).m_20615_((Level)level);
        egg.setEggBreed(this.m_21187_().nextBoolean() ? this.breed : mate.breed);
        if (this.m_8077_() && animal.m_8077_()) {
            String babyName;
            String p1Name = this.m_7770_().getString();
            String p2Name = animal.m_7770_().getString();
            if (p1Name.contains(" ") || p2Name.contains(" ")) {
                String[] p1Names = p1Name.split(" ");
                String[] p2Names = p2Name.split(" ");
                p1Name = StringUtils.capitalize((String)p1Names[this.m_21187_().nextInt(p1Names.length)]);
                p2Name = StringUtils.capitalize((String)p2Names[this.m_21187_().nextInt(p2Names.length)]);
                babyName = this.m_21187_().nextBoolean() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
            } else {
                p1Name = this.m_21187_().nextBoolean() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
                p2Name = this.m_21187_().nextBoolean() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
                p2Name = StringUtils.capitalize((String)p2Name);
                babyName = this.m_21187_().nextBoolean() ? p1Name + p2Name : p2Name + p1Name;
            }
            egg.m_6593_((Component)new TextComponent(babyName));
        }
        this.addReproCount();
        mate.addReproCount();
        egg.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        level.m_7967_((Entity)egg);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        TameableDragon offspring = (TameableDragon)((EntityType)DMLRegistry.DRAGON.get()).m_20615_((Level)level);
        offspring.setBreed(this.getBreed());
        return offspring;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TamableAnimal tameable;
        return !(target instanceof TamableAnimal) || !Objects.equals((tameable = (TamableAnimal)target).m_142480_(), owner);
    }

    public boolean m_6549_(EntityType<?> typeIn) {
        return !this.isHatchling() && super.m_6549_(typeIn);
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isHatchling() && super.m_6779_(target);
    }

    public boolean m_5807_() {
        LivingEntity driver;
        Entity entity = this.m_6688_();
        return entity instanceof LivingEntity && this.m_21830_(driver = (LivingEntity)entity);
    }

    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void setRidingPlayer(Player player) {
        player.m_146922_(this.m_146908_());
        player.m_146926_(this.m_146909_());
        player.m_20329_((Entity)this);
    }

    public void m_7332_(Entity passenger) {
        Entity riddenByEntity = this.m_6688_();
        if (riddenByEntity != null) {
            Vec3 pos = new Vec3(0.0, this.m_6048_() + riddenByEntity.m_6049_(), (double)this.m_6134_()).m_82524_((float)Math.toRadians(-this.f_20883_)).m_82549_(this.m_20182_());
            passenger.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (this.m_146895_() instanceof LivingEntity) {
                LivingEntity rider = (LivingEntity)riddenByEntity;
                rider.f_19860_ = rider.m_146909_();
                rider.f_19859_ = rider.m_146908_();
                rider.f_20883_ = this.f_20883_;
            }
        }
    }

    public boolean m_6673_(DamageSource src) {
        Entity srcEnt = src.m_7639_();
        if (srcEnt != null && (srcEnt == this || this.m_20363_(srcEnt))) {
            return true;
        }
        if (src == DamageSource.f_19323_ || src == DamageSource.f_19314_) {
            return true;
        }
        return this.breed.immunities().contains((Object)src.m_19385_()) || super.m_6673_(src);
    }

    public double getHealthRelative() {
        return (double)this.m_21223_() / (double)this.m_21233_();
    }

    public int getMaxDeathTime() {
        return 120;
    }

    public void m_6210_() {
        double posXTmp = this.m_20185_();
        double posYTmp = this.m_20186_();
        double posZTmp = this.m_20189_();
        boolean onGroundTmp = this.f_19861_;
        super.m_6210_();
        this.m_6034_(posXTmp, posYTmp, posZTmp);
        this.f_19861_ = onGroundTmp;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        float height = this.m_21825_() ? 2.15f : 2.75f;
        float scale = this.m_6134_();
        return new EntityDimensions(2.75f * scale, height * scale, false);
    }

    public int m_146764_() {
        return this.f_146733_;
    }

    public void updateAgeProgress() {
        float growth = -this.breed.growthTime();
        float min = Math.min(this.m_146764_(), 0);
        this.ageProgress = 1.0f - min / growth;
    }

    public float getAgeProgress() {
        return this.ageProgress;
    }

    private void updateAgeProperties() {
        this.m_146762_((Integer)this.f_19804_.m_135370_(DATA_AGE));
        this.updateAgeProgress();
        this.m_6210_();
        AttributeModifier mod = new AttributeModifier(SCALE_MODIFIER_UUID, "Dragon size modifier", (double)this.m_6134_(), AttributeModifier.Operation.ADDITION);
        for (Attribute attribute : new Attribute[]{Attributes.f_22276_, Attributes.f_22281_}) {
            AttributeInstance instance = this.m_21051_(attribute);
            instance.m_22130_(mod);
            instance.m_22118_(mod);
        }
    }

    public boolean isHatchling() {
        return this.getAgeProgress() < 0.5f;
    }

    public boolean isJuvenile() {
        return this.getAgeProgress() >= 0.5f && this.getAgeProgress() < 1.0f;
    }

    public boolean isAdult() {
        return this.getAgeProgress() >= 1.0f;
    }

    public boolean m_6162_() {
        return !this.isAdult();
    }

    public void m_6863_(boolean baby) {
        this.m_146762_(baby ? -this.breed.growthTime() : 0);
        this.f_19804_.m_135381_(DATA_AGE, (Object)this.f_146733_);
    }

    public void m_146740_(int p_146741_, boolean p_146742_) {
        super.m_146740_(p_146741_, p_146742_);
        this.f_19804_.m_135381_(DATA_AGE, (Object)this.m_146764_());
    }

    public boolean isServer() {
        return !this.f_19853_.f_46443_;
    }

    public DragonAnimator getAnimator() {
        return this.animator;
    }

    public boolean m_6040_() {
        return this.breed.immunities().contains((Object)"drown");
    }

    public boolean m_5825_() {
        return super.m_5825_() || this.breed.immunities().contains((Object)"onFire");
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        for (Ability ability : this.getBreed().abilities()) {
            ability.onMove(this);
        }
    }

    public boolean m_5830_() {
        if (this.f_19794_) {
            return false;
        }
        AABB collider = this.m_142469_().m_82406_((double)(this.m_20205_() * 0.2f));
        return BlockPos.m_121921_((AABB)collider).anyMatch(pos -> {
            BlockState state = this.f_19853_.m_8055_(pos);
            return !state.m_60795_() && state.m_60828_((BlockGetter)this.f_19853_, pos) && Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)this.f_19853_, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)collider), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public Vec3 m_7371_(float p_20309_) {
        return new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
    }
}

