/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;

public class DragonEgg
extends Entity {
    public static final float WIDTH = 0.9f;
    public static final float HEIGHT = 0.9f;
    public static final int HABITAT_UPDATE_INTERVAL = 200;
    public static final int DEFAULT_HATCH_TIME = 12000;
    public static final int BREED_TRANSITION_TIME = 200;
    public static final int MIN_HABITAT_POINTS = 2;
    public static final byte HATCH_ID = 1;
    public static final byte WIGGLE_ID = 2;
    public static final String NBT_HATCH_TIME = "HatchTime";
    public static final EntityDataAccessor<String> BREED = SynchedEntityData.m_135353_(DragonEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public DragonBreed breed = BreedRegistry.getFallback();
    public final TransitionHandler transitioner;
    private int hatchTime = this.breed.hatchTime();

    public DragonEgg(EntityType<? extends Entity> type, Level level) {
        super(type, level);
        this.transitioner = new TransitionHandler();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BREED, (Object)"");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_(NBT_HATCH_TIME, this.hatchTime);
        tag.m_128359_("Breed", this.breed.getRegistryName().toString());
        this.transitioner.save(tag);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setHatchTime(tag.m_128451_(NBT_HATCH_TIME));
        this.setEggBreed(BreedRegistry.get(tag.m_128461_("Breed")));
        this.transitioner.read(tag);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(BREED)) {
            this.breed = BreedRegistry.get((String)this.f_19804_.m_135370_(BREED));
        } else if (key.equals(TransitionHandler.TRANSITION_BREED)) {
            BreedRegistry.registry().m_6612_(new ResourceLocation((String)this.f_19804_.m_135370_(TransitionHandler.TRANSITION_BREED))).ifPresentOrElse(this.transitioner::begin, this.transitioner::abort);
        }
        super.m_7350_(key);
    }

    public void setEggBreed(DragonBreed breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed.getRegistryName().toString());
    }

    public void setHatchTime(int time) {
        this.hatchTime = time;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_5825_() {
        return true;
    }

    protected Component m_5677_() {
        return new TranslatableComponent(((Block)DMLRegistry.EGG_BLOCK.get()).m_7705_(), new Object[]{new TranslatableComponent(this.breed.getTranslationKey())});
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82542_(0.3, 0.98, 0.3));
        this.f_19853_.m_6249_((Entity)this, this.m_142469_(), e -> !(e instanceof Player)).forEach(arg_0 -> ((DragonEgg)this).m_7334_(arg_0));
        this.transitioner.tick();
        if (!this.f_19853_.f_46443_) {
            if (DMLConfig.updateHabitats() && this.hatchTime > 200 && !this.transitioner.isRunning() && this.f_19797_ % 200 == 0) {
                this.updateHabitat();
            }
            if (--this.hatchTime <= 0) {
                this.hatch();
                return;
            }
            if ((float)this.hatchTime < (float)this.breed.hatchTime() * 0.25f && this.f_19796_.nextInt(Math.max(10, this.hatchTime)) == 0) {
                this.wiggle();
            }
        } else {
            this.addHatchingParticles();
        }
        super.m_8119_();
    }

    public void addHatchingParticles() {
        double px = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5);
        double py = this.m_20186_() + this.f_19796_.nextDouble();
        double pz = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5);
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        ParticleOptions particle = this.breed.getHatchParticles(this.f_19796_);
        if (particle.m_6012_() == ParticleTypes.f_123805_) {
            py = this.m_20186_() + (this.f_19796_.nextDouble() - 0.5) + 1.0;
        }
        if (particle.m_6012_() == ParticleTypes.f_123760_) {
            ox = (this.f_19796_.nextDouble() - 0.5) * 2.0;
            oy = (this.f_19796_.nextDouble() - 0.5) * 2.0;
            oz = (this.f_19796_.nextDouble() - 0.5) * 2.0;
        }
        this.f_19853_.m_7106_(particle, px, py, pz, ox, oy, oz);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            this.m_19983_(DMLEggBlock.Item.create(this.breed, this.hatchTime));
            this.m_146870_();
        } else if (amount > 4.0f) {
            this.m_146870_();
        }
        return super.m_6469_(source, amount);
    }

    public void updateHabitat() {
        DragonBreed winner = null;
        int prevPoints = 0;
        for (DragonBreed breed : BreedRegistry.registry()) {
            int points = breed.getHabitatPoints(this.f_19853_, this.m_142538_());
            if (points <= 2 || points <= prevPoints) continue;
            winner = breed;
            prevPoints = points;
        }
        if (winner != null && winner != this.breed) {
            this.transitioner.begin(winner);
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 1: {
                this.hatch();
                break;
            }
            case 2: {
                this.wiggle();
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public void hatch() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12535_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
            TameableDragon dragon = (TameableDragon)((EntityType)DMLRegistry.DRAGON.get()).m_20615_(this.f_19853_);
            dragon.setBreed(this.breed);
            dragon.m_6863_(true);
            dragon.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            dragon.m_6593_(this.m_7770_());
            this.f_19853_.m_7967_((Entity)dragon);
        }
        this.m_146870_();
    }

    public void wiggle() {
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12534_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)2);
        }
    }

    public class TransitionHandler {
        private static final EntityDataAccessor<String> TRANSITION_BREED = SynchedEntityData.m_135353_(DragonEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        private static final String NBT_TRANSITION_BREED = "TransitionBreed";
        private static final String NBT_TRANSITION_TIME = "TransitionTime";
        public DragonBreed transitioningBreed;
        public int transitionTime;

        public TransitionHandler() {
            DragonEgg.this.f_19804_.m_135372_(TRANSITION_BREED, (Object)"");
        }

        public void tick() {
            if (this.isRunning()) {
                if (--this.transitionTime == 0 && !DragonEgg.this.f_19853_.f_46443_) {
                    DragonEgg.this.setEggBreed(this.transitioningBreed);
                    DragonEgg.this.f_19804_.m_135381_(TRANSITION_BREED, (Object)"");
                }
                if (DragonEgg.this.f_19853_.f_46443_) {
                    for (int i = 0; i < 200 - this.transitionTime; ++i) {
                        double px = DragonEgg.this.m_20185_() + (DragonEgg.this.f_19796_.nextDouble() - 0.5);
                        double py = DragonEgg.this.m_20186_() + DragonEgg.this.f_19796_.nextDouble();
                        double pz = DragonEgg.this.m_20189_() + (DragonEgg.this.f_19796_.nextDouble() - 0.5);
                        DustParticleOptions particle = this.transitioningBreed.getDustParticles(DragonEgg.this.f_19796_);
                        DragonEgg.this.f_19853_.m_7106_((ParticleOptions)particle, px, py, pz, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        public void begin(DragonBreed transitioningBreed, int transitionTime) {
            this.transitioningBreed = transitioningBreed;
            this.transitionTime = transitionTime;
            DragonEgg.this.f_19804_.m_135381_(TRANSITION_BREED, (Object)transitioningBreed.getRegistryName().toString());
        }

        public void begin(DragonBreed transitioningBreed) {
            this.begin(transitioningBreed, 200);
        }

        public void abort() {
            this.transitioningBreed = null;
            this.transitionTime = 0;
        }

        public boolean isRunning() {
            return this.transitionTime > 0;
        }

        public void save(CompoundTag tag) {
            if (this.transitioningBreed != null) {
                tag.m_128359_(NBT_TRANSITION_BREED, this.transitioningBreed.getRegistryName().toString());
                tag.m_128405_(NBT_TRANSITION_TIME, this.transitionTime);
            }
        }

        public void read(CompoundTag tag) {
            BreedRegistry.registry().m_6612_(new ResourceLocation(tag.m_128461_(NBT_TRANSITION_BREED))).ifPresent(breed -> this.begin((DragonBreed)((Object)breed), tag.m_128451_(NBT_TRANSITION_TIME)));
        }
    }
}

