/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon;

import com.github.kay9.dragonmounts.DMLConfig;
import com.github.kay9.dragonmounts.DMLRegistry;
import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.client.DragonEggRenderer;
import com.github.kay9.dragonmounts.dragon.DragonEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class DMLEggBlock
extends DragonEggBlock
implements EntityBlock {
    public DMLEggBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76365_).m_60913_(3.0f, 9.0f).m_60953_(s -> 1).m_60955_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new Entity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof Entity) {
            Entity e = (Entity)entity;
            DMLEggBlock.startHatching(e.getBreed(), e.getHatchTime(), level, pos);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6256_(BlockState state, Level level, BlockPos at, Player player) {
        Entity e;
        BlockEntity blockEntity = level.m_7702_(at);
        if (blockEntity instanceof Entity && (e = (Entity)blockEntity).getBreed().getRegistryName().m_135815_().equals("end")) {
            super.m_6256_(Blocks.f_50260_.m_49966_(), level, at, player);
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static void startHatching(DragonBreed breed, Level level, BlockPos pos) {
        DMLEggBlock.startHatching(breed, breed.hatchTime(), level, pos);
    }

    protected void m_6788_(FallingBlockEntity falling) {
        BlockEntity blockEntity = falling.f_19853_.m_7702_(falling.m_142538_());
        if (blockEntity instanceof Entity) {
            Entity e = (Entity)blockEntity;
            falling.f_31944_ = e.m_187482_();
        }
    }

    public static void startHatching(DragonBreed breed, int hatchTime, Level level, BlockPos pos) {
        if (!level.f_46443_) {
            DragonEgg egg = (DragonEgg)((EntityType)DMLRegistry.DRAGON_EGG.get()).m_20615_(level);
            egg.setEggBreed(breed);
            egg.setHatchTime(hatchTime);
            egg.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
            level.m_7967_((net.minecraft.world.entity.Entity)egg);
        }
    }

    public static boolean overrideVanillaDragonEgg(Level level, BlockPos pos, Player player) {
        Optional end;
        if (DMLConfig.allowEggOverride() && level.m_8055_(pos).m_60713_(Blocks.f_50260_) && (end = BreedRegistry.registry().m_6612_(DragonMountsLegacy.id("end"))).isPresent()) {
            level.m_7471_(pos, false);
            if (level.f_46443_) {
                player.m_6674_(InteractionHand.MAIN_HAND);
            }
            DMLEggBlock.startHatching((DragonBreed)((Object)end.get()), level, pos);
            return true;
        }
        return false;
    }

    public static class Entity
    extends BlockEntity {
        private DragonBreed breed;
        private int hatchTime;

        public Entity(BlockPos pWorldPosition, BlockState pBlockState) {
            super((BlockEntityType)DMLRegistry.EGG_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
            this.setBreed(BreedRegistry.getFallback());
            this.setHatchTime(this.breed.hatchTime());
        }

        protected void m_183515_(CompoundTag tag) {
            super.m_183515_(tag);
            tag.m_128359_("Breed", this.breed.getRegistryName().toString());
            tag.m_128405_("HatchTime", this.hatchTime);
        }

        public void m_142466_(CompoundTag tag) {
            super.m_142466_(tag);
            this.setBreed(BreedRegistry.get(tag.m_128461_("Breed")));
            this.setHatchTime(tag.m_128451_("HatchTime"));
        }

        @Nullable
        public Packet<ClientGamePacketListener> m_183216_() {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }

        public CompoundTag m_5995_() {
            return this.m_187482_();
        }

        public void setBreed(DragonBreed breed) {
            this.breed = breed;
        }

        public DragonBreed getBreed() {
            return this.breed;
        }

        public void setHatchTime(int time) {
            this.hatchTime = time;
        }

        public int getHatchTime() {
            return this.hatchTime;
        }
    }

    public static class Item
    extends BlockItem {
        public Item() {
            super((Block)DMLRegistry.EGG_BLOCK.get(), new Item.Properties().m_41497_(Rarity.RARE).m_41491_(CreativeModeTab.f_40753_));
        }

        public Component m_7626_(ItemStack stack) {
            String name;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || (name = tag.m_128461_("ItemName")).isEmpty()) {
                name = BreedRegistry.getFallback().getTranslationKey();
            }
            return new TranslatableComponent(this.m_5524_(), new Object[]{new TranslatableComponent(name)});
        }

        public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
            if (this.m_41389_(tab)) {
                for (DragonBreed breed : BreedRegistry.registry()) {
                    items.add((Object)Item.create(breed, breed.hatchTime()));
                }
            }
        }

        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltips, TooltipFlag pFlag) {
            LocalPlayer player;
            int time;
            super.m_7373_(stack, level, tooltips, pFlag);
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            if (tag != null && (time = tag.m_128451_("HatchTime")) != 0) {
                tooltips.add((Component)new TranslatableComponent(this.m_5524_() + ".remaining_time", new Object[]{time / 20}).m_130940_(ChatFormatting.GRAY));
            }
            if ((player = Minecraft.m_91087_().f_91074_) != null && player.m_150110_().f_35937_) {
                tooltips.add((Component)new TranslatableComponent(this.m_5524_() + ".change_breeds").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC, ChatFormatting.UNDERLINE}));
            }
        }

        public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
            if (player.m_150110_().f_35937_ && target instanceof TameableDragon) {
                TameableDragon dragon = (TameableDragon)target;
                CompoundTag tag = stack.m_41737_("BlockEntityTag");
                if (tag != null) {
                    dragon.setBreed(BreedRegistry.get(tag.m_128461_("Breed")));
                    return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
                }
            }
            return super.m_6880_(stack, player, target, hand);
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(DragonEggRenderer.INSTANCE);
        }

        public static ItemStack create(DragonBreed breed, int hatchTime) {
            CompoundTag rootTag = new CompoundTag();
            CompoundTag bETag = new CompoundTag();
            bETag.m_128359_("Breed", breed.getRegistryName().toString());
            bETag.m_128405_("HatchTime", hatchTime);
            rootTag.m_128365_("BlockEntityTag", (Tag)bETag);
            rootTag.m_128359_("ItemName", breed.getTranslationKey());
            ItemStack stack = new ItemStack((ItemLike)DMLRegistry.EGG_BLOCK_ITEM.get());
            stack.m_41751_(rootTag);
            return stack;
        }
    }
}

