/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.data.loot.DragonEggLootMod;
import com.github.kay9.dragonmounts.dragon.DMLEggBlock;
import com.github.kay9.dragonmounts.dragon.DragonEgg;
import com.github.kay9.dragonmounts.dragon.DragonSpawnEgg;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

public class DMLRegistry {
    private static final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> REGISTRIES = new HashMap();
    public static final RegistryObject<Block> EGG_BLOCK = DMLRegistry.register("dragon_egg", ForgeRegistries.Keys.BLOCKS, DMLEggBlock::new);
    public static final RegistryObject<Item> EGG_BLOCK_ITEM = DMLRegistry.register(EGG_BLOCK.getId().m_135815_(), ForgeRegistries.Keys.ITEMS, DMLEggBlock.Item::new);
    public static final RegistryObject<Item> SPAWN_EGG = DMLRegistry.register("spawn_egg", ForgeRegistries.Keys.ITEMS, DragonSpawnEgg::new);
    public static final RegistryObject<SoundEvent> DRAGON_BREATHE_SOUND = DMLRegistry.sound("entity.dragon.breathe");
    public static final RegistryObject<SoundEvent> DRAGON_STEP_SOUND = DMLRegistry.sound("entity.dragon.step");
    public static final RegistryObject<SoundEvent> DRAGON_DEATH_SOUND = DMLRegistry.sound("entity.dragon.death");
    public static final RegistryObject<EntityType<TameableDragon>> DRAGON = DMLRegistry.entity("dragon", EntityType.Builder.m_20704_(TameableDragon::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.75f, 2.75f).m_20702_(10).m_20717_(3));
    public static final RegistryObject<EntityType<DragonEgg>> DRAGON_EGG = DMLRegistry.entity("dragon_egg", EntityType.Builder.m_20704_(DragonEgg::new, (MobCategory)MobCategory.MISC).m_20699_(0.9f, 0.9f).m_20702_(5).m_20717_(8));
    public static final RegistryObject<BlockEntityType<DMLEggBlock.Entity>> EGG_BLOCK_ENTITY = DMLRegistry.register("dragon_egg", ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, () -> BlockEntityType.Builder.m_155273_(DMLEggBlock.Entity::new, (Block[])new Block[]{(Block)EGG_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<GlobalLootModifierSerializer<DragonEggLootMod>> EGG_LOOT_MODIFIER = DMLRegistry.register("dragon_egg_loot", ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, DragonEggLootMod.Serializer::new);
    public static final BooleanSupplier FLIGHT_DESCENT_KEY = DMLRegistry.keymap("flight_descent", 90, "key.categories.movement");

    protected static void init(IEventBus bus) {
        REGISTRIES.values().forEach(r -> r.register(bus));
        REGISTRIES.clear();
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> entity(String name, EntityType.Builder<T> builder) {
        return DMLRegistry.register(name, ForgeRegistries.Keys.ENTITY_TYPES, () -> builder.m_20712_("dragonmounts:" + name));
    }

    private static RegistryObject<SoundEvent> sound(String name) {
        return DMLRegistry.register(name, ForgeRegistries.Keys.SOUND_EVENTS, () -> new SoundEvent(DragonMountsLegacy.id(name)));
    }

    private static BooleanSupplier keymap(String name, int defaultMapping, String category) {
        if (FMLLoader.getDist().isClient() && Minecraft.m_91087_() != null) {
            KeyMapping keymap = new KeyMapping(String.format("key.%s.%s", "dragonmounts", name), defaultMapping, category);
            ClientRegistry.registerKeyBinding((KeyMapping)keymap);
            return () -> ((KeyMapping)keymap).m_90857_();
        }
        return () -> {
            throw new RuntimeException("Cannot invoke '" + name + "' key mapping on server side!");
        };
    }

    private static <T extends IForgeRegistryEntry<T>, I extends T> RegistryObject<I> register(String name, ResourceKey<Registry<T>> forType, Supplier<? extends I> sup) {
        DeferredRegister registry = REGISTRIES.computeIfAbsent(forType, t -> {
            ForgeRegistry fr = RegistryManager.ACTIVE.getRegistry(forType);
            if (fr == null) {
                return DeferredRegister.create((ResourceKey)forType, (String)"dragonmounts");
            }
            return DeferredRegister.create((IForgeRegistry)fr, (String)"dragonmounts");
        });
        return registry.register(name, sup);
    }
}

