/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity;

import com.nitespring.monsterplus.config.CommonConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LavaSquid
extends Monster {
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    public float tx;
    public float ty;
    public float tz;

    public LavaSquid(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_19796_.setSeed(this.m_142049_());
        this.tentacleSpeed = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 0.2).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 100.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LavaSquidAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SquidRandomMovementGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SquidFleeGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected float m_6431_(Pose p_29975_, EntityDimensions p_29976_) {
        return p_29976_.f_20378_ * 0.5f;
    }

    public static boolean checkLavaSquidSpawnRules(EntityType<LavaSquid> p_218985_, ServerLevelAccessor p_218986_, MobSpawnType p_218987_, BlockPos p_218988_, Random p_218989_) {
        return LavaSquid.m_21400_(p_218985_, (LevelAccessor)p_218986_, (MobSpawnType)p_218987_, (BlockPos)p_218988_, (Random)p_218989_) && (Boolean)CommonConfig.spawn_lava_squid.get() != false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    protected SoundEvent m_7975_(DamageSource p_29980_) {
        return SoundEvents.f_12440_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_5825_() {
        return true;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor server, DifficultyInstance difficulty, MobSpawnType type, SpawnGroupData group, CompoundTag nbt) {
        Vec3 pos = this.m_20182_();
        Vec3 deltaPos = new Vec3(0.0, 5.0, 0.0);
        this.m_146884_(pos.m_82549_(deltaPos));
        return super.m_6518_(server, difficulty, type, group, nbt);
    }

    public boolean m_6914_(LevelReader p_21433_) {
        return p_21433_.m_45784_((Entity)this);
    }

    public void m_8107_() {
        super.m_8107_();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.f_19853_.f_46443_) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement -= (float)Math.PI * 2;
                if (this.f_19796_.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
                }
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            }
        }
        if (this.tentacleMovement < (float)Math.PI) {
            float f = this.tentacleMovement / (float)Math.PI;
            this.tentacleAngle = Mth.m_14031_((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
            if ((double)f > 0.75) {
                this.speed = 1.0f;
                this.rotateSpeed = 1.0f;
            } else {
                this.rotateSpeed *= 0.8f;
            }
        } else {
            this.tentacleAngle = 0.0f;
            this.speed *= 0.9f;
            this.rotateSpeed *= 0.99f;
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20334_(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
        }
        Vec3 vec3 = this.m_20184_();
        double d0 = vec3.m_165924_();
        this.f_20883_ += (-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f - this.f_20883_) * 0.1f;
        this.m_146922_(this.f_20883_);
        this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
        this.xBodyRot += (-((float)Mth.m_14136_((double)d0, (double)vec3.f_82480_)) * 57.295776f - this.xBodyRot) * 0.1f;
    }

    private Vec3 rotateVector(Vec3 p_29986_) {
        Vec3 vec3 = p_29986_.m_82496_(this.xBodyRotO * ((float)Math.PI / 180));
        return vec3.m_82524_(-this.f_20884_ * ((float)Math.PI / 180));
    }

    public void m_7023_(Vec3 p_29984_) {
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_7822_(byte p_29957_) {
        if (p_29957_ == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.m_7822_(p_29957_);
        }
    }

    public void setMovementVector(float p_29959_, float p_29960_, float p_29961_) {
        this.tx = p_29959_;
        this.ty = p_29960_;
        this.tz = p_29961_;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    static class LavaSquidAttackGoal
    extends Goal {
        private final LavaSquid squid;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public LavaSquidAttackGoal(LavaSquid p_32247_) {
            this.squid = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.squid.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.squid.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.squid.m_5448_();
            if (livingentity != null) {
                boolean flag = this.squid.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.squid.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.squid.m_7327_((Entity)livingentity);
                    }
                    this.squid.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.squid.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.squid.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.squid.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= this.squid.m_21187_().nextInt(4) + 1) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.squid.m_20067_()) {
                                this.squid.f_19853_.m_5898_((Player)null, 1018, this.squid.m_142538_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SmallFireball smallfireball = new SmallFireball(this.squid.f_19853_, (LivingEntity)this.squid, this.squid.m_21187_().nextGaussian(d1, 2.297 * d4), d2, this.squid.m_21187_().nextGaussian(d3, 2.297 * d4));
                                double rn = (this.squid.m_21187_().nextInt(10) + 1) / 6;
                                smallfireball.m_6034_(this.squid.m_20185_() + Math.cos(Math.PI * 2 * rn), this.squid.m_20227_(0.5) + 0.5 + 2.5 * Math.sin(Math.PI * 2 * rn), this.squid.m_20189_() + Math.sin(Math.PI * 2 * rn));
                                this.squid.f_19853_.m_7967_((Entity)smallfireball);
                            }
                        }
                    }
                    this.squid.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.squid.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.squid.m_21133_(Attributes.f_22277_);
        }
    }

    class SquidRandomMovementGoal
    extends Goal {
        private final LavaSquid squid;

        public SquidRandomMovementGoal(LavaSquid p_30004_) {
            this.squid = p_30004_;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int i = this.squid.m_21216_();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.m_21187_().nextInt(SquidRandomMovementGoal.m_186073_((int)50)) == 0 || !this.squid.hasMovementVector()) {
                float f = this.squid.m_21187_().nextFloat() * ((float)Math.PI * 2);
                float f1 = Mth.m_14089_((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.m_21187_().nextFloat() * 0.2f;
                float f3 = Mth.m_14031_((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }

    class SquidFleeGoal
    extends Goal {
        private int fleeTicks;

        SquidFleeGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = LavaSquid.this.m_142581_();
            if (livingentity != null) {
                return LavaSquid.this.m_20280_((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void m_8056_() {
            this.fleeTicks = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.fleeTicks;
            LivingEntity livingentity = LavaSquid.this.m_142581_();
            if (livingentity != null) {
                Vec3 vec3 = new Vec3(LavaSquid.this.m_20185_() - livingentity.m_20185_(), LavaSquid.this.m_20186_() - livingentity.m_20186_(), LavaSquid.this.m_20189_() - livingentity.m_20189_());
                BlockState blockstate = LavaSquid.this.f_19853_.m_8055_(new BlockPos(LavaSquid.this.m_20185_() + vec3.f_82479_, LavaSquid.this.m_20186_() + vec3.f_82480_, LavaSquid.this.m_20189_() + vec3.f_82481_));
                if (blockstate.m_60795_()) {
                    double d0 = vec3.m_82553_();
                    if (d0 > 0.0) {
                        vec3.m_82541_();
                        double d1 = 3.0;
                        if (d0 > 5.0) {
                            d1 -= (d0 - 5.0) / 5.0;
                        }
                        if (d1 > 0.0) {
                            vec3 = vec3.m_82490_(d1);
                        }
                    }
                    LavaSquid.this.setMovementVector((float)vec3.f_82479_ / 20.0f, (float)vec3.f_82480_ / 20.0f, (float)vec3.f_82481_ / 20.0f);
                }
                if (this.fleeTicks % 10 == 5) {
                    LavaSquid.this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175834_, LavaSquid.this.m_20185_(), LavaSquid.this.m_20186_(), LavaSquid.this.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

