/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity;

import com.nitespring.monsterplus.common.entity.Eye;
import com.nitespring.monsterplus.common.entity.SpectralSkeleton;
import com.nitespring.monsterplus.common.entity.projectiles.PurpleFireball;
import com.nitespring.monsterplus.common.entity.projectiles.SpikeCountdown;
import com.nitespring.monsterplus.config.CommonConfig;
import com.nitespring.monsterplus.core.init.EntityInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Abyssologer
extends SpellcasterIllager {
    public Abyssologer(EntityType<? extends SpellcasterIllager> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
        this.f_21364_ = 10;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Mob.class, 8.0f, 0.6, 1.0, p_28879_ -> p_28879_ == this.m_5448_()));
        this.f_21345_.m_25352_(4, (Goal)new SummonEyeSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new SummonSkeletonSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new BlindnessSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new SpikeSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new FireballSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.m_7307_(p_32665_)) {
            return true;
        }
        if (p_32665_ instanceof Eye) {
            return this.m_7307_((Entity)((Eye)p_32665_).getOwner());
        }
        if (p_32665_ instanceof SpectralSkeleton) {
            return this.m_7307_((Entity)((SpectralSkeleton)p_32665_).getOwner());
        }
        if (p_32665_ instanceof LivingEntity && ((LivingEntity)p_32665_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_32665_.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return SoundEvents.f_11866_;
    }

    public static boolean checkAbyssologerSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, Random p_219018_) {
        return p_219015_.m_46791_() != Difficulty.PEACEFUL && Abyssologer.m_33008_((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (Random)p_219018_) && Abyssologer.m_21400_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (Random)p_219018_) && blockPos.m_123342_() <= 40 && (Boolean)CommonConfig.spawn_abyssologer.get() != false;
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        CastingSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        public void m_8037_() {
            if (Abyssologer.this.m_5448_() != null) {
                Abyssologer.this.m_21563_().m_24960_((Entity)Abyssologer.this.m_5448_(), (float)Abyssologer.this.m_8085_(), (float)Abyssologer.this.m_8132_());
            }
        }
    }

    class SummonEyeSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions eyeCountTargeting;

        SummonEyeSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
            this.eyeCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int i = Abyssologer.this.f_19853_.m_45971_(Eye.class, this.eyeCountTargeting, (LivingEntity)Abyssologer.this, Abyssologer.this.m_142469_().m_82400_(16.0)).size();
            return Abyssologer.this.f_19796_.nextInt(6) + 1 > i;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 720;
        }

        protected void m_8130_() {
            ServerLevel serverlevel = (ServerLevel)Abyssologer.this.f_19853_;
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = Abyssologer.this.m_142538_().m_142082_(-2 + Abyssologer.this.f_19796_.nextInt(5), 1, -2 + Abyssologer.this.f_19796_.nextInt(5));
                Eye eye = (Eye)((EntityType)EntityInit.EYE.get()).m_20615_(Abyssologer.this.f_19853_);
                eye.m_20035_(blockpos, 0.0f, 0.0f);
                eye.m_6518_((ServerLevelAccessor)serverlevel, Abyssologer.this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                eye.setOwner((Mob)Abyssologer.this);
                eye.setLimitedLife(20 * (30 + Abyssologer.this.f_19796_.nextInt(90)));
                serverlevel.m_47205_((Entity)eye);
            }
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11868_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class SummonSkeletonSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions eyeCountTargeting;

        SummonSkeletonSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
            this.eyeCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int i = Abyssologer.this.f_19853_.m_45971_(SpectralSkeleton.class, this.eyeCountTargeting, (LivingEntity)Abyssologer.this, Abyssologer.this.m_142469_().m_82400_(16.0)).size();
            return Abyssologer.this.f_19796_.nextInt(5) + 1 > i;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 560;
        }

        protected void m_8130_() {
            ServerLevel serverlevel = (ServerLevel)Abyssologer.this.f_19853_;
            for (int i = 0; i < 2; ++i) {
                BlockPos blockpos = Abyssologer.this.m_142538_().m_142082_(-2 + Abyssologer.this.f_19796_.nextInt(5), 1, -2 + Abyssologer.this.f_19796_.nextInt(5));
                SpectralSkeleton skeleton = (SpectralSkeleton)((EntityType)EntityInit.SPECTRAL_SKELETON.get()).m_20615_(Abyssologer.this.f_19853_);
                skeleton.m_20035_(blockpos, 0.0f, 0.0f);
                skeleton.m_6518_((ServerLevelAccessor)serverlevel, Abyssologer.this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                skeleton.setOwner((Mob)Abyssologer.this);
                skeleton.setLimitedLife(20 * (30 + Abyssologer.this.f_19796_.nextInt(90)));
                serverlevel.m_47205_((Entity)skeleton);
            }
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11868_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class BlindnessSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        BlindnessSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            return (Boolean)CommonConfig.do_abyssologer_darkness.get() != false && !Abyssologer.this.m_5448_().m_21023_(MobEffects.f_19610_);
        }

        protected int m_8089_() {
            return 35;
        }

        protected int m_8067_() {
            return 720;
        }

        protected void m_8130_() {
            Abyssologer.this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 700));
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11867_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class SpikeSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        SpikeSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 60;
        }

        protected void m_8130_() {
            LivingEntity livingentity = Abyssologer.this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), Abyssologer.this.m_20186_());
            double d1 = Math.max(livingentity.m_20186_(), Abyssologer.this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - Abyssologer.this.m_20189_()), (double)(livingentity.m_20185_() - Abyssologer.this.m_20185_()));
            if (Abyssologer.this.m_20280_((Entity)livingentity) < 16.0 || Abyssologer.this.m_20280_((Entity)livingentity) < 30.0 && Abyssologer.this.m_21187_().nextBoolean()) {
                float f1;
                for (int i = 0; i < 5; ++i) {
                    f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.createSpellEntity(Abyssologer.this.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, Abyssologer.this.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 1);
                }
                for (int j = 0; j < 10; ++j) {
                    f1 = f + (float)j * (float)Math.PI * 2.0f / 10.0f + 1.2566371f;
                    this.createSpellEntity(Abyssologer.this.m_20185_() + (double)Mth.m_14089_((float)f1) * 3.0, Abyssologer.this.m_20189_() + (double)Mth.m_14031_((float)f1) * 3.0, d0, d1, f1, 2);
                }
                for (int k = 0; k < 15; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 15.0f + 2.256637f;
                    this.createSpellEntity(Abyssologer.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 4.5, Abyssologer.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 4.5, d0, d1, f2, 3);
                }
            } else {
                int randomPattern = new Random().nextInt(4) + 1;
                switch (randomPattern) {
                    case 1: {
                        for (int l = 0; l < 16; ++l) {
                            double d2 = 1.25 * (double)(l + 1);
                            int j = 1 * l;
                            this.createSpellEntity(Abyssologer.this.m_20185_() + (double)Mth.m_14089_((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), Abyssologer.this.m_20189_() + (double)Mth.m_14031_((float)f) * d2 + ((double)new Random().nextFloat() - 0.5), d0, d1, f, j);
                        }
                        break;
                    }
                    case 2: {
                        float f1;
                        this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_(), Abyssologer.this.m_5448_().m_20189_(), d0, d1, 0.0f, 0);
                        for (int i = 0; i < 5; ++i) {
                            f1 = f + (float)i * (float)Math.PI * 0.4f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f1) * 1.0, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f1) * 1.0, d0, d1, f1, 1);
                        }
                        for (int j = 0; j < 8; ++j) {
                            f1 = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 2);
                        }
                        for (int k = 0; k < 25; ++k) {
                            float f2 = f + (float)k * (float)Math.PI * 2.0f / 25.0f + 2.566371f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f2) * 5.0, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f2) * 5.0, d0, d1, f2, 3);
                        }
                        break;
                    }
                    case 3: {
                        this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_(), Abyssologer.this.m_5448_().m_20189_(), d0, d1, 0.0f, 0);
                        for (int i = 0; i < 4; ++i) {
                            float f1 = f + (float)i * (float)Math.PI * 2.0f / 4.0f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f1) * 0.75, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f1) * 0.75, d0, d1, f1, 1);
                        }
                        for (int k = 0; k < 20; ++k) {
                            float f2 = f + (float)k * (float)Math.PI * 2.0f / 20.0f + 2.566371f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f2) * 4.0, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f2) * 4.0, d0, d1, f2, 3);
                        }
                        break;
                    }
                    case 4: {
                        float f1;
                        this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_(), Abyssologer.this.m_5448_().m_20189_(), d0, d1, 0.0f, 0);
                        for (int i = 0; i < 4; ++i) {
                            f1 = f + (float)i * (float)Math.PI * 2.0f / 4.0f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f1) * 0.75, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f1) * 0.75, d0, d1, f1, 1);
                        }
                        for (int j = 0; j < 7; ++j) {
                            f1 = f + (float)j * (float)Math.PI * 2.0f / 7.0f + 1.2566371f;
                            this.createSpellEntity(Abyssologer.this.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f1) * 1.25, Abyssologer.this.m_5448_().m_20189_() + (double)Mth.m_14031_((float)f1) * 1.25, d0, d1, f1, 2);
                        }
                        break;
                    }
                }
            }
        }

        private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
            BlockPos blockpos = new BlockPos(p_32673_, p_32676_, p_32674_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = Abyssologer.this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)Abyssologer.this.f_19853_, blockpos1, Direction.UP)) continue;
                if (!Abyssologer.this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = Abyssologer.this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)Abyssologer.this.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_32675_) - 1);
            if (flag) {
                Abyssologer.this.f_19853_.m_7967_((Entity)new SpikeCountdown(Abyssologer.this.f_19853_, 4.0f, p_32673_, (double)blockpos.m_123342_() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)Abyssologer.this, 25));
            }
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11867_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    class FireballSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        FireballSpellGoal() {
            super((SpellcasterIllager)Abyssologer.this);
        }

        protected int m_8089_() {
            return 20;
        }

        protected int m_8067_() {
            return 25;
        }

        protected void m_8130_() {
            Vec3 pos = Abyssologer.this.m_20182_();
            Vec3 posO = new Vec3(pos.f_82479_, pos.f_82480_ + 2.5, pos.f_82481_);
            Vec3 pos1 = Abyssologer.this.m_5448_().m_20182_();
            Vec3 posT = new Vec3(pos1.f_82479_, Abyssologer.this.m_5448_().m_20227_(0.5), pos1.f_82481_);
            double d0 = Math.sqrt((posT.f_82479_ - posO.f_82479_) * (posT.f_82479_ - posO.f_82479_) + (posT.f_82480_ - posO.f_82480_) * (posT.f_82480_ - posO.f_82480_) + (posT.f_82481_ - posO.f_82481_) * (posT.f_82481_ - posO.f_82481_));
            Vec3 aim = new Vec3((posT.f_82479_ - posO.f_82479_) / d0, (posT.f_82480_ - posO.f_82480_) / d0, (posT.f_82481_ - posO.f_82481_) / d0);
            this.launchFireball(posO, aim, 4.0f);
        }

        private void launchFireball(Vec3 pos, Vec3 aim, float damage) {
            PurpleFireball fireball = new PurpleFireball((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.PURPLE_FIREBALL.get()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), aim.m_7096_() * 0.5, aim.m_7098_() * 0.5, aim.m_7094_() * 0.5, Abyssologer.this.f_19853_, (LivingEntity)Abyssologer.this, damage);
            Abyssologer.this.m_183503_().m_7967_((Entity)fireball);
            Abyssologer.this.m_5496_(SoundEvents.f_12287_, 0.5f, 0.75f);
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11867_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

