/*
 * Decompiled with CFR 0.152.
 */
package net.witixin.armoreablemobs;

import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.witixin.armoreablemobs.ArmorGroup;
import net.witixin.armoreablemobs.GameStagesHelper;
import net.witixin.armoreablemobs.PackModeHelper;

public class CommonClass {
    public static final String MOD_ID = "armoreablemobs";
    public static final String MOD_NAME = "Armoreable_Mobs";
    public static Map<EntityType, List<ArmorGroup>> armorList = new HashMap<EntityType, List<ArmorGroup>>();
    public static Map<EntityType, BlockState> entityBlockStateMapOverrides = new HashMap<EntityType, BlockState>();
    public static Map<BlockState, Map<EquipmentSlot, IItemStack>> blockstateArmorOverries = new HashMap<BlockState, Map<EquipmentSlot, IItemStack>>();

    public static ArmorGroup onSpawn(Entity fakeEntity, BiPredicate<LivingEntity, List<String>> predicate) {
        ArmorGroup selectedGroup;
        LivingEntity entity;
        if (fakeEntity instanceof LivingEntity && armorList.containsKey((entity = (LivingEntity)fakeEntity).m_6095_()) && GameStagesHelper.delegatePredicate(entity, (selectedGroup = CommonClass.rollGroup(armorList.get(entity.m_6095_()))).getStages(), predicate) && PackModeHelper.playerPackmodeNearby(entity, selectedGroup.getPackmode())) {
            if (ArmorGroup.overrideArmorGroups.containsKey(entity.m_6095_())) {
                ArmorGroup.overrideArmorGroups.get(entity.m_6095_()).forEach((equipmentSlot, iItemStack) -> entity.m_8061_(equipmentSlot, iItemStack.getInternal()));
                return new ArmorGroup(ArmorGroup.overrideArmorGroups.get(entity.m_6095_()).values().stream().map(IItemStack::getInternal).iterator());
            }
            CommonClass.attachItems(selectedGroup, entity);
            if (entityBlockStateMapOverrides.containsKey(entity.m_6095_()) && entityBlockStateMapOverrides.get(entity.m_6095_()) != null && entity.m_183503_().m_8055_(entity.m_142538_().m_7495_()).equals(entityBlockStateMapOverrides.get(entity.m_6095_()))) {
                ArmorGroup g = new ArmorGroup(EntityType.m_20613_((EntityType)entity.m_6095_()) + entityBlockStateMapOverrides.get(entity.m_6095_()).m_60734_().toString());
                blockstateArmorOverries.get(entity.m_183503_().m_8055_(entity.m_142538_().m_7495_())).forEach(g::inSlot);
                CommonClass.attachItems(g, entity);
                return g;
            }
            return selectedGroup;
        }
        return null;
    }

    public static void onReload() {
        armorList.clear();
    }

    private static ArmorGroup rollGroup(List<ArmorGroup> group) {
        int position;
        double maxWeight = 0.0;
        for (ArmorGroup individual : group) {
            maxWeight += individual.getWeight();
        }
        double r = Math.random() * maxWeight;
        for (position = 0; position < group.size() && !((r -= group.get(position).getWeight()) <= 0.0); ++position) {
        }
        return group.get(position);
    }

    private static void attachItems(ArmorGroup g, LivingEntity livingEntity) {
        Map<EquipmentSlot, ItemStack> slotMap = new ArmorGroup(livingEntity.m_6168_().iterator(), livingEntity.m_21205_(), livingEntity.m_21206_()).getMap();
        for (EquipmentSlot eqslt : g.getMap().keySet()) {
            ItemStack stack = g.getStackInSlot(eqslt);
            if (!slotMap.get(eqslt).m_41619_()) continue;
            livingEntity.m_8061_(eqslt, stack);
        }
    }
}

